//-----------------------------------------------------------------------
// コントローラーのアナログスティックの傾きを表示
// カラーセンサーを追加(LEDでスティックの傾きを輝度で表現)
// モーターも動かす
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
#include <RPlib.h>
#include <LedControl.h>
#include <ColorSensor.h>
#include <PS2X_lib.h>
#include <Tone.h>
#include <math.h>

LedControl lc = LedControl(11, 13, 1);               //７セグメントLEDを使うときのオマジナイ
PS2X ps2x;
Tone tone1;
RPmotor mc(MC1);

void setup(){
    tone1.begin(D3);
    ColorSensor.begin(100);
    ps2x.config_gamepad(13, 11, 10, 12, true, true); //ピン設定
    lc.shutdown(0, false);                           //７セグメントLEDをリセット
    lc.setIntensity(0, 4);                           //色の濃さ(0-8)
    lc.clearDisplay(0);                              //表示クリア
}

int stick = 0;

void loop(){
    ps2x.read_gamepad();                             //コントローラーから値を読み込む
    // dist=ussRead(US1);
    stick = ps2x.Analog(PSS_LX);                     //アナログスティック（左）左右
    ColorSensor.led(3, stick);
    tone1.play(abs(stick) * 10, 100);
    lc.setDec(0, stick);                             //変数stickの内容を表示
    mc.rotate(map(stick, -128, 128, -100, 100));
    delay(100);
}
