//-----------------------------------------------------------------------
// USS1センサーで距離を表示
// カラーセンサーを追加(LEDで距離を輝度で表現)
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
#include <RPlib.h>
#include <LedControl.h>
#include <ColorSensor.h>
#include <PS2X_lib.h>

LedControl lc = LedControl(11, 13, 1);               //７セグメントLEDを使うときのオマジナイ
PS2X ps2x;

void setup(){
    ColorSensor.begin(100);
    ps2x.config_gamepad(13, 11, 10, 12, true, true); //ピン設定
    lc.shutdown(0, false);                           //７セグメントLEDをリセット
    lc.setIntensity(0, 4);                           //色の濃さ(0-8)
    lc.clearDisplay(0);                              //表示クリア
}

int stick = 0;

void loop(){
    ps2x.read_gamepad();                             //コントローラーから値を読み込む
    // dist=ussRead(US1);
    stick = ps2x.Analog(PSS_LX);                     //アナログスティック（左）左右
    ColorSensor.led(3, stick);
    lc.setDec(0, stick);                             //変数stickの内容を表示
    delay(100);
}
