//-----------------------------------------------------------------------
// スイッチでカウント
// digitalReadバージョン
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
#include <RPlib.h>
#include <LedControl.h>

LedControl lc = LedControl(11, 13, 1); //７セグメントLEDを使うときのオマジナイ

void setup(){
    pinMode(D2, INPUT_PULLUP);
    lc.shutdown(0, false);             //７セグメントLEDをリセット
    lc.setIntensity(0, 4);             //色の濃さ(0-8)
    lc.clearDisplay(0);                //表示クリア
}

int count = 0;

void loop(){
    if(digitalRead(D2) == HIGH){
        count++;                       //カウント
    }
    lc.setDec(0, count);               //変数countの内容を表示
    delay(10);
}
