//-----------------------------------------------------------------------
// スロットマシン１
// 0-9カウンターを回す
// A0でストップをかける
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
#include <LedControl.h>

LedControl lc = LedControl(11, 13, 1); //7セグメントLEDを使うときのオマジナイ

void setup(){
    pinMode(A0, INPUT);                //A0ピンを入力にする
    lc.shutdown(0, false);             //7セグメントLEDをリセット
    lc.setIntensity(0, 5);             //色の濃さ
    lc.clearDisplay(0);                //表示クリア
}

int cnt0 = 0;
int sw0  = 0;

void loop(){
    if(digitalRead(A0) == HIGH){       //もしA0がおされたら
        sw0 = 1;                       //フラグを立てる
    }
    if(sw0 == 0){                      //もしA0がおされていなければ
        cnt0++;                        //カウントアップ
    }
    if(cnt0 > 9){                      //もし９より大きくなったら
        cnt0 = 0;                      //数字をリセット
    }
    lc.setDigit(0, 0, cnt0, false);    //一番左の列に結果を表示
    delay(100);                        //1/10秒毎
}
