//-----------------------------------------------------------------------
// 7セグメントLED（ルーレット2）
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

#include <LedControl.h>

LedControl lc = LedControl(11, 13, 1); //7セグメントLEDを使うときのオマジナイ

void setup(){
    lc.shutdown(0, false);             //7セグメントLEDをリセット
    lc.setIntensity(0, 4);             //色の濃さ(0-8)
    lc.clearDisplay(0);                //表示クリア
}

void loop(){
    int rx[] = {0, 1, 2, 3, 3, 3, 3, 2, 1, 0, 0, 0};
    int ry[] = {1, 1, 1, 1, 2, 5, 0, 0, 0, 0, 4, 6};

    for(int i = 0; i < 12; i++){
        lc.setLed(0, rx[i], ry[i], HIGH);
        delay(100);
        lc.setLed(0, rx[i], ry[i], LOW);
    }
}
