//-----------------------------------------------------------------------
// 7セグメントLED(アニメーション1ウネウネ)
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

#include <LedControl.h>

LedControl lc = LedControl(11, 13, 1); //7セグメントLEDを使うときのオマジナイ

void setup(){
    lc.shutdown(0, false);             //7セグメントLEDをリセット
    lc.setIntensity(0, 4);             //色の濃さ(0-8)
    lc.clearDisplay(0);                //表示クリア
}

void loop(){
    int anim[] = {
        4, 6, 1, 2, 5, 7
    };

    for(int j = 0; j < 4; j++){
        for(int i = 0; i < 6; i++){
            lc.setLed(0, j, anim[i], HIGH);
            delay(100);
            lc.setLed(0, j, anim[i], LOW);
        }
    }
}
