//-----------------------------------------------------------------------
// マイコンボードのポート9/10/11に繋がったLEDを点滅させる
// チャレンジ解答例
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
//-----------------------------------------------------------------------
int rled = 9;                      //rled(red ledの略) という名の変数を用意する(rled=9)
int bled = 10;                     //bled(blue ledの略) という名の変数を用意する(bled=10)
int gled = 11;                     //gled(green ledの略) という名の変数を用意する(gled=11)

void setup(){
    pinMode(rled, OUTPUT);         //9番のピン(rled=9)を出力に設定する
    pinMode(gled, OUTPUT);         //10番のピン(gled=10)を出力に設定する
    pinMode(bled, OUTPUT);         //11番のピン(bled=11)を出力に設定する
}

void loop(){                       //新たに変数「i」を用意し、for文でo(初期値)
    for (int i = 0; i < 255; i++){ //for文で0〜255の範囲で変数「i」を１ずつ加算する
        analogWrite(rled, i);      //digitalWriteからanalogWriteに変更し出力
                                   //analogに出力する値を0〜255の範囲で指定できる
        delay(10);
    }
    for (int i = 254; i > 0; i--){
        analogWrite(rled, i);
        delay(10);
    }
}
