//
// エンコーダテスト
//  ENC1ポートのテスト
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

#include <TimerOne.h>
#include <LedControl.h>

LedControl lc = LedControl(11,13,1);        //７セグメントLEDを使うためのオマジナイ

// A相ピン割り当て
#define ENC_A0 9
#define ENC_A1 A2
#define ENC_A2 12

// B相ピン割り当て
#define ENC_B0 0
#define ENC_B1 A3
#define ENC_B2 10

// 前回値(Bit1:A相、Bit0:B相)
volatile int oldEnc0;
volatile int oldEnc1;
volatile int oldEnc2;

// エンコーダ値
volatile int encValue0;
volatile int encValue1;
volatile int encValue2;

void doEncoderCounter(void){

    int newEnc0 = ( digitalRead(ENC_A0) ? 0 : 2 ) | ( digitalRead(ENC_B0) ? 0 : 1 );

    if (0){
        // do nothing
    }
    else
    if (0 == oldEnc0)
    {
        if (2 == newEnc0){        // up
            encValue0++;
        }
        else
        if (1 == newEnc0)         // down
        {
            encValue0--;
        }
    }
    else
    if (1 == oldEnc0)
    {
        if (0 == newEnc0){        // up
            encValue0++;
        }
        else
        if (3 == newEnc0)         // down
        {
            encValue0--;
        }
    }
    else
    if (2 == oldEnc0)
    {
        if (3 == newEnc0){        // up
            encValue0++;
        }
        else
        if (0 == newEnc0)         // down
        {
            encValue0--;
        }
    }
    else
    if (3 == oldEnc0)
    {
        if (1 == newEnc0){        // up
            encValue0++;
        }
        else
        if (2 == newEnc0)         // down
        {
            encValue0--;
        }
    }
    oldEnc0 = newEnc0;
    //------------------------
    int newEnc1 = ( digitalRead(ENC_A1) ? 0 : 2 ) | ( digitalRead(ENC_B1) ? 0 : 1 );

    if (0){
        // do nothing
    }
    else
    if (0 == oldEnc1)
    {
        if (2 == newEnc1){        // up
            encValue1++;
        }
        else
        if (1 == newEnc1)         // down
        {
            encValue1--;
        }
    }
    else
    if (1 == oldEnc1)
    {
        if (0 == newEnc1){        // up
            encValue1++;
        }
        else
        if (3 == newEnc1)         // down
        {
            encValue1--;
        }
    }
    else
    if (2 == oldEnc1)
    {
        if (3 == newEnc1){        // up
            encValue1++;
        }
        else
        if (0 == newEnc1)         // down
        {
            encValue1--;
        }
    }
    else
    if (3 == oldEnc1)
    {
        if (1 == newEnc1){        // up
            encValue1++;
        }
        else
        if (2 == newEnc1)         // down
        {
            encValue1--;
        }
    }
    oldEnc1 = newEnc1;
    //------------------------
    int newEnc2 = ( digitalRead(ENC_A2) ? 0 : 2 ) | ( digitalRead(ENC_B2) ? 0 : 1 );

    if (0){
        // do nothing
    }
    else
    if (0 == oldEnc2)
    {
        if (2 == newEnc2){        // up
            encValue2++;
        }
        else
        if (1 == newEnc2)         // down
        {
            encValue2--;
        }
    }
    else
    if (1 == oldEnc2)
    {
        if (0 == newEnc2){        // up
            encValue2++;
        }
        else
        if (3 == newEnc2)         // down
        {
            encValue2--;
        }
    }
    else
    if (2 == oldEnc2)
    {
        if (3 == newEnc2){        // up
            encValue2++;
        }
        else
        if (0 == newEnc2)         // down
        {
            encValue2--;
        }
    }
    else
    if (3 == oldEnc2)
    {
        if (1 == newEnc2){        // up
            encValue2++;
        }
        else
        if (2 == newEnc2)         // down
        {
            encValue2--;
        }
    }
    oldEnc2 = newEnc2;
    //------------------------
}

void setup(){
    lc.shutdown(0,false);      //７セグメントLEDをリセット
    lc.setIntensity(0,8);      //色の濃さ
    lc.clearDisplay(0);        //表示クリア
    //------------------------------
    pinMode(ENC_A0, INPUT);
    pinMode(ENC_B0, INPUT);
    encValue0 = 0;
    oldEnc0 = ( digitalRead(ENC_A0) ? 0 : 2 ) | ( digitalRead(ENC_B0) ? 0 : 1 );
    //------------------------------
    pinMode(ENC_A1, INPUT);
    pinMode(ENC_B1, INPUT);
    encValue1 = 0;
    oldEnc1 = ( digitalRead(ENC_A1) ? 0 : 2 ) | ( digitalRead(ENC_B1) ? 0 : 1 );
    //------------------------------
    pinMode(ENC_A2, INPUT);
    pinMode(ENC_B2, INPUT);
    encValue2 = 0;
    oldEnc2 = ( digitalRead(ENC_A2) ? 0 : 2 ) | ( digitalRead(ENC_B2) ? 0 : 1 );
    //------------------------------
    Timer1.initialize(100);
    Timer1.attachInterrupt(doEncoderCounter);
}

void loop(){
    int enc;
    noInterrupts();
    enc = encValue1;        //ENC1を表示する
    interrupts();

    lc.setDec(0,enc);
    delay(100);
}
