//
// ジャイロセンサーのフィードバックプログラム
// 目標値を向くロボット
//テンプレート
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
#include <RPomniDirect.h>
#include <RPlib.h>
#include "Wire.h"
#include <math.h>
#include "I2Cdev.h"
#include "MPU6050.h"
#include <LedControl.h>

LedControl lc = LedControl(11, 13, 1); //７セグメントLEDを使うときのオマジナイ
RPomniDirect omniBot(1.0f, 1.0f, 1.0f, 50.0f);
MPU6050 accelgyro;                     //姿勢センサーを使うときのオマジナイ

int16_t ax, ay, az;
int16_t gx, gy, gz;
int16_t mx, my, mz;
long ave = 0;

//7セグメントLEDルーレット用
int rx[] = {
    0, 1, 2, 3, 3, 3, 3, 2, 1, 0, 0, 0
};
int ry[] = {
    1, 1, 1, 1, 2, 5, 0, 0, 0, 0, 4, 6
};

void setup(){
    //------------ 7セグメントLEDの準備
    lc.shutdown(0, false);                                                 //７セグメントLEDをリセット
    lc.setIntensity(0, 8);                                                 //色の濃さ
    lc.clearDisplay(0);                                                    //表示クリア
    //-----------  姿勢センサーの準備
    Wire.begin();
    accelgyro.initialize();
    //-----------  姿勢センサーの準備

    //-------  ジャイロ初期値計測
    for(int i = 0; i < 500; i++){
        lc.setLed(0, rx[i % 12], ry[i % 12], HIGH);                        //7セグメントLEDルーレット処理
        accelgyro.getMotion9(&ax, &ay, &az, &gx, &gy, &gz, &mx, &my, &mz); //姿勢センサーの検出
        ave += gz;
        lc.setLed(0, rx[i % 12], ry[i % 12], LOW);                         //7セグメントLEDルーレット処理
    }
    ave /= 500;
}

float ang = 0;

void loop(){
    accelgyro.getMotion9(&ax, &ay, &az, &gx, &gy, &gz, &mx, &my, &mz);     //姿勢センサーの検出
    ang += (( gz - ave ) / 16.4 / 8 ) * 0.0255;                            //+-250 range modeの変換 [deg/sec] x センシングに25.5msecかかっている
    lc.setDec(0, ang);                                                //z軸周りの角度のLED表示(deg)
}
