#include "Wire.h"
#include "I2Cdev.h"
#include "MPU6050.h"
#include <Tone.h>
#include <RPlib.h>

Tone spk;

int16_t ax, ay, az;
int16_t gx, gy, gz;
int16_t mx, my, mz;
int16_t temp;

MPU6050 accelgyro;
bool blinkState = false;

void setup(){
    Wire.begin();
    Serial.begin(115200);
    
    Serial.println("Initializing I2C devices...");
    accelgyro.initialize();
    accelgyro.setFullScaleAccelRange(MPU6050_ACCEL_FS_16);
    
    Serial.println("Testing device connections...");
    Serial.println(accelgyro.testConnection() ? "MPU6050 connection successful" : "MPU6050 connection failed");
    pinMode(13, OUTPUT);
    spk.begin(D2);

}

int freq;

void loop(){
  
    //姿勢検出シールドのセンサーの値をチェックし、各変数に記録する
    accelgyro.getMotion9(&ax, &ay, &az, &gx, &gy, &gz, &mx, &my, &mz);

    //センサーの値を記録した各変数の値を、シリアルモニタに表示する
    //ax～azは加速度センサ、gx～gzは各速度センサ、一番最後は温度センサ（『気温』ではなく『センサーの温度』になることに注意）
    Serial.print("a/g/T:\t");
    Serial.print(ax); Serial.print("\t");
    Serial.print(ay); Serial.print("\t");
    Serial.print(az); Serial.print("\t");
    Serial.print(gx); Serial.print("\t");
    Serial.print(gy); Serial.print("\t");
    Serial.print(gz); Serial.print("\t");
    Serial.println(accelgyro.getTemperature() / 333.87 + 21);

    //マイコンボード上のLEDを点滅させる（動作チェック用）
    blinkState = !blinkState;
    digitalWrite(13, blinkState);
    
    //値の更新を少し遅くしてシリアルモニタを見やすくする
    delay(100);

    freq = abs(ax);
    freq = constrain(freq, 0, 4000);
    freq = map(freq, 0, 4000, 262, 523);  //「やってみよう」修正箇所はこの行（constrainで上限を4000にしたので、こちらの値も8000から変更）
    spk.play(440,500);
    delay(50);
    spk.stop();
    delay(500);

    
}
