//-----------------------------------------------------------------------
// 　LED line 回転(プロペラ)
//  角度平行バージョン
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

//ライブラリを取り込む
#include <Sprite.h>
#include <Matrix.h>
#include "Wire.h"
#include <math.h>
#include "I2Cdev.h"
#include "MPU6050.h"

Matrix myMatrix = Matrix(11, 13, 1); //マトリクスLEDを使用するときのオマジナイ
MPU6050 accelgyro;                   //姿勢センサーを使うときのオマジナイ
int16_t ax, ay, az;
int16_t gx, gy, gz;
int16_t mx, my, mz;
long ave = 0;
void setup(){
    myMatrix.clear();        //マトリクスLEDの表示を消す
    //-----------  姿勢センサーの準備
    Wire.begin();
    accelgyro.initialize();  //姿勢センサーの準備

    //-------  ジャイロ初期値計測
    for(int i = 0; i < 500; i++){
        myMatrix.line(0,i % 8,7,i % 8);                                    //座標(x1,y1)から座標(x2,y2)へ線を引く
        accelgyro.getMotion9(&ax, &ay, &az, &gx, &gy, &gz, &mx, &my, &mz); //姿勢センサーの検出
        ave += gz;
        myMatrix.clear();
    }
    ave /= 500;
}

int x1,x2,y1,y2;        //始点と終点に使うx・y座標を用意
int x,y;

float ang = 0,rang;

void loop(){

    accelgyro.getMotion9(&ax, &ay, &az, &gx, &gy, &gz, &mx, &my, &mz); //姿勢センサーの検出
    ang += (( gz - ave ) / 16.4 / 8 ) / 100 * 2.8;
    rang = ang + 45;                                                   //補正する
    myMatrix.clear();

    if(rang >= 0 && rang < 90){
        if(rang >= 0 && rang < 10) y = 7;
        if(rang >= 10 && rang < 20) y = 6;
        if(rang >= 20 && rang < 30) y = 5;
        if(rang >= 30 && rang < 45) y = 4;
        if(rang >= 45 && rang < 55) y = 3;
        if(rang >= 55 && rang < 70) y = 2;
        if(rang >= 70 && rang < 80) y = 1;
        if(rang >= 80 && rang < 90) y = 0;
        //y軸に沿ってラインが動く
        x1 = 0;
        x2 = 7;
        y1 = y;
        y2 = 7 - y;
    }

    if(rang < 0 && rang > -90){
        if(rang < 0 && rang > -10) x = 0;
        if(rang <= -10 && rang > -20) x = 1;
        if(rang <= -20 && rang > -30) x = 2;
        if(rang <= -30 && rang > -45) x = 3;
        if(rang <= -45 && rang > -55) x = 4;
        if(rang <= -55 && rang > -70) x = 5;
        if(rang <= -70 && rang > -80) x = 6;
        if(rang <= -80 && rang > -90) x = 7;
        //x軸に沿ってラインが動く
        y1 = 7;
        y2 = 0;
        x1 = x;
        x2 = 7 - x;
    }
    myMatrix.line(x1,y1,x2,y2);                                        //座標(x1,y1)から座標(x2,y2)へ線を引く
}
