//
// 姿勢センサーの値を７セグメントLEDで表示する
// z軸に対する傾きの角度を表示する
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
#include <LedControl.h>
#include "Wire.h"
#include <math.h>
#include "I2Cdev.h"
#include "MPU6050.h"

#define G 16000
LedControl lc = LedControl(11,13,1); //7セグメントLEDを使うときのオマジナイ

MPU6050 accelgyro;                   //姿勢センサーを使うときのオマジナイ

int16_t ax, ay, az;
int16_t gx, gy, gz;
int16_t mx, my, mz;

void setup(){
    //------------ 7セグメントLEDの準備
    lc.shutdown(0,false);      //７セグメントLEDをリセット
    lc.setIntensity(0,8);      //色の濃さ
    lc.clearDisplay(0);        //表示クリア
    //-----------  姿勢センサーの準備
    Wire.begin();
    accelgyro.initialize();    //姿勢センサーの準備
}

double deg;
double f_az;

void loop(){

    accelgyro.getMotion9(&ax, &ay, &az, &gx, &gy, &gz, &mx, &my, &mz); //姿勢センサーの検出

    f_az = az;                                                         //ダブルに宣言し直す
    deg = acos(f_az / G) * 180 / PI;

    lc.setDec(0,(int)deg);                                             //z軸に対する傾きの角度を7セグメントLEDに表示

    delay(500);
}
