//-----------------------------------------------------------------------
// 　LED line 回転(プロペラ)
//  加速度バージョン
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

//ライブラリを取り込む
#include <Sprite.h>
#include <Matrix.h>
#include "Wire.h"
#include <math.h>
#include "I2Cdev.h"
#include "MPU6050.h"

Matrix myMatrix = Matrix(11, 13, 1); //マトリクスLEDを使用するときのオマジナイ
MPU6050 accelgyro;                   //姿勢センサーを使うときのオマジナイ
int16_t ax, ay, az;
int16_t gx, gy, gz;
int16_t mx, my, mz;
float temp;

void setup(){
    myMatrix.clear();       //マトリクスLEDの表示を消す
    //-----------  姿勢センサーの準備
    Wire.begin();
    accelgyro.initialize(); //姿勢センサーの準備
}

int x1,x2,y1,y2;            //始点と終点に使うx・y座標を用意
int dtime;                  //LEDが移動する待ち時間

void loop(){
    //y軸に沿ってラインが動く
    x1 = 0;
    x2 = 7;
    accelgyro.getMotion9(&ax, &ay, &az, &gx, &gy, &gz, &mx, &my, &mz);        //姿勢センサーの検出
    dtime = map(abs(az),0,16000,1,100);
    //dtime=50;

    for(int y = 0; y <= 7; y++){
        y1 = y;
        y2 = 7 - y;
        myMatrix.line(x1,y1,x2,y2);        //座標(x1,y1)から座標(x2,y2)へ線を引く
        delay(dtime);
        myMatrix.clear();
    }

    //x軸に沿ってラインが動く
    y1 = 7;
    y2 = 0;

    for(int x = 1; x <= 6; x++){
        x1 = x;
        x2 = 7 - x;
        myMatrix.line(x1,y1,x2,y2);        //座標(x1,y1)から座標(x2,y2)へ線を引く
        delay(dtime);
        myMatrix.clear();
    }
}
