//-----------------------------------------------------------------------
//ドットLEDが動く(ぐるぐる回る)
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

#include <Sprite.h>        // Sprite before Matrix
#include <Matrix.h>
#include "Wire.h"
#include <math.h>
#include "I2Cdev.h"
#include "MPU6050.h"
int dtime;                  //LEDが移動する待ち時間
//                   DIN, CLK, LOAD, #chips
Matrix myMatrix = Matrix(11, 13, 1);
MPU6050 accelgyro;          //姿勢センサーを使うときのオマジナイ
void setup(){
    myMatrix.clear();       //マトリクスLEDの表示を消す
    //-----------  姿勢センサーの準備
    Wire.begin();
    accelgyro.initialize(); //姿勢センサーの準備
}

int16_t ax, ay, az;
int16_t gx, gy, gz;
int16_t mx, my, mz;
char x = 0, y = 0;                                                     //変数charをxとyという名前で使う(はじめは0)
void loop(){
    accelgyro.getMotion9(&ax, &ay, &az, &gx, &gy, &gz, &mx, &my, &mz); //姿勢センサーの検出
    dtime = map(abs(az),0,16000,1,100);
    y = 0;
    for (x = 0; x < 8; x++){
        myMatrix.write(x, y, HIGH);       //LEDを点灯
        delay(dtime);
        myMatrix.write(x, y, LOW);        //LEDを消灯
    }
    x = 7;
    for (y = 1; y < 8; y++){
        myMatrix.write(x, y, HIGH);       //LEDを点灯
        delay(dtime);
        myMatrix.write(x, y, LOW);        //LEDを消灯
    }
    y = 7;
    for (x = 6; x > 0; x--){
        myMatrix.write(x, y, HIGH);       //LEDを点灯
        delay(dtime);
        myMatrix.write(x, y, LOW);        //LEDを消灯
    }
    x = 0;
    for (y = 7; y > 0; y--){
        myMatrix.write(x, y, HIGH);       //LEDを点灯
        delay(dtime);
        myMatrix.write(x, y, LOW);        //LEDを消灯
    }
}
