//
// 姿勢センサーの値を７セグメントLEDで表示する
// z軸方向のGを測ろう
// 最大値を保持しておく
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
#include <LedControl.h>
#include "Wire.h"
#include <math.h>
#include "I2Cdev.h"
#include "MPU6050.h"

LedControl lc = LedControl(11,13,1); //７セグメントLEDを使うときのオマジナイ

MPU6050 accelgyro;                   //姿勢センサーを使うときのオマジナイ

int16_t ax, ay, az;
int16_t gx, gy, gz;
int16_t mx, my, mz;
float temp;

void setup(){
//------------ 7セグメントLEDの準備
    lc.shutdown(0,false);                                              //7セグメントLEDをリセット
    lc.setIntensity(0,8);                                              //色の濃さ
    lc.clearDisplay(0);                                                //表示クリア
//-----------  姿勢センサーの準備
    Wire.begin();
    accelgyro.initialize();                                            //姿勢センサーの準備
    accelgyro.setFullScaleAccelRange(MPU6050_ACCEL_FS_16);             //加速度計のレンジを調整(最大検出)
}

int a_max = 0;                                                         //a_maxという名前の変数を用意
void loop(){

    accelgyro.getMotion9(&ax, &ay, &az, &gx, &gy, &gz, &mx, &my, &mz); //姿勢センサーの検出
    temp = accelgyro.getTemperature() / 333.87 + 21;                   //温度検出

    a_max = max(a_max,az);                                             //max関数を使い、大きい方の値を返す

    lc.setDec(0,a_max / 20);                                           //z軸の加速度を7セグメントLEDに表示
    delay(10);
}
