
#define ENC_A0 1
#define ENC_A1 A2
#define ENC_A2 10
#define ENC_B0 9
#define ENC_B1 A3
#define ENC_B2 12
volatile int cycleTick = 0;

volatile int tick[3];
int old[3];

// エンコーダ値
volatile int encValue[3];
volatile int encTime[3];


double Setpoint[3], Input[3], Output[3];
double Kp = 0.21, Ki = 31.1, Kd = 0.0;
//double Kp = 0.8, Ki = 41.1, Kd = 0.0;

PID wheelPID1(&Input[1], &Output[1], &Setpoint[1], Kp, Ki, Kd, DIRECT);
PID wheelPID2(&Input[2], &Output[2], &Setpoint[2], Kp, Ki, Kd, DIRECT);

int feedback[3];

#define TIMEOUT 300        // *SAMPLETIME [usec] encoder timer out
#define SAMPLETIME 125     //[usec] encoder sampling time
#define FBcycle 160        //*SAMPLETIME[usec]  20msec velocity control feedback

#define SPEED_L 186        //30RPM : = 30*140/60 = 70p/sec = 14.2857ms/p : /125usec=: 300 - 114.28 tick
#define SPEED_M 235        //50 RPM : = 50*140/60 =  116.66p/s = 8.5714ms/p : /125usec = : 300 -  68.57 tick
#define SPEED_H 253        //70 RPM : = 70*140/60 =  326.666 p/s = 6.1224ms/p : /125usec =: 300 - 48.979 tick
#define SPEED_STOP 0
//L 1 roll = 2 sec
//M 1 roll = 1.2sec
//H 1 roll = 0.8671sec

#define MIN_ABS_SPEED 30

//RPmotor mc0(MC0);//MC0に繋がっているモータを指定する
RPmotor mc1(MC1);        //MC1に繋がっているモータを指定する
RPmotor mc2(MC2);        //MC2に繋がっているモータを指定する

void updateEncoder(void);

void fbEnable(int no);

void rotate_enc(int rpm, int mot);

void enc_init(){
    // pinMode(ENC_A0, INPUT);
    //  pinMode(ENC_B0, INPUT);
    pinMode(ENC_A1, INPUT);
    pinMode(ENC_B1, INPUT);
    pinMode(ENC_A2, INPUT);
    pinMode(ENC_B2, INPUT);

    Setpoint[0] = 0.0;
    Setpoint[1] = 0.0;
    Setpoint[2] = 0.0;

    wheelPID1.SetOutputLimits(-255, 255);
    wheelPID2.SetOutputLimits(-255, 255);
    //turn the PID on
    wheelPID1.SetMode(AUTOMATIC);
    wheelPID2.SetMode(AUTOMATIC);
    wheelPID1.SetSampleTime(5);        //5msec周期で速度フィードバック
    wheelPID2.SetSampleTime(5);        //5msec周期で速度フィードバック

    Timer1.initialize(SAMPLETIME);
    Timer1.attachInterrupt(updateEncoder);

    fbEnable(1);
    fbEnable(2);

    rotate_enc(-SPEED_STOP,1);
    rotate_enc(SPEED_STOP,2);
}

void pid_reset(){
    wheelPID1.SetMode(MANUAL);
    wheelPID2.SetMode(MANUAL);
    wheelPID1.SetMode(AUTOMATIC);
    wheelPID2.SetMode(AUTOMATIC);
    wheelPID1.SetTunings(Kp, Ki, Kd);
    wheelPID2.SetTunings(Kp, Ki, Kd);
    encValue[1] = 0;
    encValue[2] = 0;
}

void fbEnable(int no){
    feedback[no] = 1;
    //; if(no ==1)wheelPID1.SetMode(AUTOMATIC);
    // if(no ==2)wheelPID2.SetMode(AUTOMATIC);
}

void fbDisable(int no){
    feedback[no] = 0;
    //if(no ==1)wheelPID1.SetMode(MANUAL);
    //  if(no ==2)wheelPID2.SetMode(MANUAL);
}

void updateEncoder(void){
    static const int d[] = {
        0, 1, -1, 0, -1, 0, 0, 1, 1, 0, 0, -1, 0, -1, 1, 0
    };
    static unsigned char p[3];
    // p[0] = (p[0] << 2 | (digitalRead(ENC_B0) << 1 | digitalRead(ENC_A0))) & 0x0f;
    // p[1] = (p[1] << 2 | (digitalRead(ENC_B1) << 1 | digitalRead(ENC_A1))) & 0x0f;
    p[1] = ( p[1] << 2 | ( PINC >> 2 & B00000011 )) & 0x0f;
    // p[2] = (p[2] << 2 | (digitalRead(ENC_B2) << 1 | digitalRead(ENC_A2))) & 0x0f;
    p[2] = ( p[2] << 2 | (( PINB & B00010000 ) >> 3 ) | (( PINB & B00000100 ) >> 2 )) & 0x0f;

    // tick[0]++;
    tick[1]++;
    tick[2]++;
    cycleTick++;
    for (int i = 1; i < 3; i++){        //三チャンネル分処理する
        encValue[i] += d[p[i]];        //パルスをカウントする

        if (tick[i] >= TIMEOUT){        //タイムアウト処理（次のパルスがこない）
            tick[i] = TIMEOUT;
            Input[i] = 0;
            encTime[i] = 0;
        }

        //  時間計測処理
        if (d[p[i]] != 0){                                //変化あった場合
            encTime[i] = d[p[i]] * ( TIMEOUT - tick[i] ); //計測時間を変数へセット
            //    encTime[i]=d[p[i]]*(tick[i]);
            Input[i] = (double)encTime[i];
            tick[i] = 0;                                  //カウンターリセット
        }
    }

    //-------------------------FeedBack Control LOOP

    int out1, out2;


    if (cycleTick >= FBcycle){
        wheelPID1.Compute();
        wheelPID2.Compute();
        if (feedback[1] == 1){

            out1 = map(abs((int)Output[1]), 0, 255, MIN_ABS_SPEED, 255);
            if (Output[1] < 0) out1 = -out1;
            mc1.rotate(out1);
        }
        else{
            mc1.rotate(0);
        }

        if (feedback[2] == 1){

            out2 = map(abs((int)Output[2]), 0, 255, MIN_ABS_SPEED, 255);
            if (Output[2] < 0) out2 = -out2;
            mc2.rotate(out2);
        }
        else {
            mc2.rotate(0);
        }
        cycleTick = 0;
    }
}

//----------------------------
void rotate_enc(int rpm, int mot){

    noInterrupts();
    Setpoint[mot] = rpm;
    interrupts();

    if (rpm == 0){
        fbDisable(mot);
    }
    else {
        fbEnable(mot);
    }
}

//----------------
void rotate_pulse(int p1, int p2){

    if(p1 < 0){
        noInterrupts();
        Setpoint[1] = -SPEED_L;
        interrupts();
    }
    else{
        noInterrupts();
        Setpoint[1] = SPEED_L;
        interrupts();
    }


    if(p2 < 0){
        noInterrupts();
        Setpoint[2] = -SPEED_L;
        interrupts();
    }
    else{
        noInterrupts();
        Setpoint[2] = SPEED_L;
        interrupts();
    }


    if (p1 == 0){
        fbDisable(1);
    }
    if (p2 == 0){
        fbDisable(2);
    }


    if(p1 != 0 || p2 != 0){
        fbEnable(1);
        fbEnable(2);
        while(abs(encValue[1]) < abs(p1) || abs(encValue[2]) < abs(p2)){
            if(abs(encValue[1]) >= abs(p1)){
                Setpoint[1] = 0;        //STOP
                fbDisable(1);
            }
            if(abs(encValue[2]) >= abs(p2)){
                Setpoint[2] = 0;        //STOP
                fbDisable(2);
            }
            delay(50);
        }
        noInterrupts();
        Setpoint[1] = 0;        //STOP
        Setpoint[2] = 0;        //STOP
        interrupts();
        fbDisable(1);
        fbDisable(2);
    }
}
