//-----------------------------------------------------------------------
// Yes OR NO
// ラインセンサはENC1接続
// U1 に黒が反応するとYES
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

#include <LedControl.h>

// A相ピン割り当て

#define ENC1_U1 A2


// B相ピン割り当て

#define ENC1_U2 A3


LedControl lc = LedControl(11,13,1);        //７セグを使うためのオマジナイ


const int yes[][7] = {
    {
        1,0,1,1,0,1,1
    }
    ,
    {
        1,1,0,1,1,0,1
    }
    ,
    {
        1,1,0,1,0,1,1
    }
    ,
    {
        0,0,0,0,0,0,0
    }
};        //YES

const int no[][7] = {
    {
        0,0,0,1,1,1,0
    }
    ,
    {
        1,0,0,1,1,1,0
    }
    ,
    {
        0,0,0,0,0,0,0
    }
    ,
    {
        0,0,0,0,0,0,0
    }
};        //no



void Yes(){
    for(int k = 0; k < 4; k++){
        for(int i = 0; i < 7; i++){
            lc.setLed(0, k,i,yes[k][i]);
        }
    }
}

void No(){
    for(int k = 0; k < 4; k++){
        for(int i = 0; i < 7; i++){
            lc.setLed(0, k,i,no[k][i]);
        }
    }
}

void setup(){
    lc.shutdown(0,false);      //７セグをリセット
    lc.setIntensity(0,8);      //色の濃さ
    lc.clearDisplay(0);        //表示クリア
    pinMode(ENC1_U1,INPUT);
    // pinMode(ENC1_U2,INPUT);
}

void loop(){

    if(digitalRead(ENC1_U1) == HIGH){        //黒ラインだったら
        Yes();
    }
    else{
        No();                                //白だったら(反射があれば)
    }
}
