//簡単エンコーダ
// U1でカウント
//  ミラーと黒のシマシマをカウントする
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

#include <LedControl.h>
LedControl lc = LedControl(11,13,1);        //７セグを使うためのオマジナイ

// A相ピン割り当て
//#define ENC_A0 A4
#define ENC0_A 9
#define ENC1_A A2
#define ENC2_A 10

// B相ピン割り当て
#define ENC0_B 0
//#define ENC_B0 A5
#define ENC1_B A3
#define ENC2_B 12

void setup(){
    lc.shutdown(0,false);      //７セグをリセット
    lc.setIntensity(0,3);      //色の濃さ
    lc.clearDisplay(0);        //表示クリア

    pinMode(ENC0_A, INPUT);
    pinMode(ENC0_B, INPUT);
    pinMode(ENC1_A, INPUT);
    pinMode(ENC1_B, INPUT);
    pinMode(ENC2_A, INPUT);
    pinMode(ENC2_B, INPUT);
    lc.setDec(0,0);            //初期表示
}

int count = 0;
int old_enc = 0;

void loop(){

    if(old_enc == 1 && digitalRead(ENC1_A) == LOW){
        old_enc = 0;
        lc.setDec(0,++count);
    }

    if(old_enc == 0 && digitalRead(ENC1_A) == HIGH){
        old_enc = 1;
        //lc.setDec(0,++count);//コメントアウトを外すと倍のカウントをします
    }
}
