
/***************************************************/
//  エンコーダとモータのテスト
// LEDぐるぐる
// 接続：MC１コネクターENC1コネクタを使う
//　　　　MC2コネクターENC2コネクタを使う
/***************************************************/
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
#include <TimerOne.h>
#include <RPlib.h>
#include <PID_v1.h>
#include "enc.h"
#include <LedControl.h>
LedControl lc = LedControl(11,13,1);        //７セグを使うためのオマジナイ

void setup(){
    enc_init();
    lc.shutdown(0,false);      //７セグをリセット
    lc.setIntensity(0,8);      //色の濃さ
    lc.clearDisplay(0);        //表示クリア
    pinMode(D2,INPUT_PULLUP);
}

int rx[] = {
    0,1,2,3,3,3,3,2,1,0,0,0
};
int ry[] = {
    1,1,1,1,2,5,0,0,0,0,4,6
};

void loop(){
    int enc,i;
    noInterrupts();
    enc = encValue[1];        //ENC1を表示する
    interrupts();

    enc = enc % 128;
    if(enc < 0){
        i = map(enc,0,-127,11,0);
    }
    else{
        i = map(enc,0,127,0,11);
    }
    lc.setLed(0, rx[i],ry[i],HIGH);
    delay(100);
    lc.setLed(0, rx[i],ry[i],LOW);
}
