//-----------------------------------------------------------------------
// パターン３、４:　右側(US2)に壁がない
// 右側の壁を探す
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

#include <RPomniDirect.h>
#include <RPlib.h>
#include <LedControl.h>

LedControl lc = LedControl(11, 13, 1);                       //７セグメントLEDを使うためのオマジナイ
RPomniDirect omniBot(1.0f, 1.0f, 1.0f, 0.0f, MC3, MC1, MC2); //以前の調整データを使ってね

void setup(){
    lc.shutdown(0, false);                                   //７セグメントLED　リセット
    lc.setIntensity(0, 4);                                   //７セグメントLED　色の濃さ設定
    lc.clearDisplay(0);                                      //７セグメントLED　表示をクリア
    //準備動作
    ussRead(US1);                                            //前方センサー検知
    ussRead(US2);                                            //右側センサー検知
    delay(500);
}

void loop(){
    //int dist1=ussRead(US1);
    int dist2 = ussRead(US2);

    if (dist2 > 10){                                         //右側に壁がないとき(前に壁があろうがなかろうが、右手法では右が開けたら右に曲がる)
        omniBot.move(0, 20, 10);                             //右側の壁を探して右カーブ走行
    }
    else{                                                    //前が開けていない、または、右の壁までの距離が10センチより遠いとき
        omniBot.move(0, 0, 0);                               //停止
    }
    lc.setDec(0, dist2);                                     //超音波距離センサーの値を読み込んで表示する
    delay(100);
}
