//-----------------------------------------------------------------------
// パターン２(改良版):　右側(US2)に壁
// 右側の壁に沿って進む
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

#include <RPomniDirect.h>
#include <RPlib.h>
#include <LedControl.h>

LedControl lc = LedControl(11, 13, 1);                              //７セグメントLEDを使うためのオマジナイ
RPomniDirect omniBot(1.3f, 1.0f, 1.0f, 0.0f, MC3, MC1, MC2);        //以前の調整データを使ってね

void setup(){
    lc.shutdown(0, false);                                          //７セグメントLED　リセット
    lc.setIntensity(0, 4);                                          //７セグメントLED　色の濃さ設定
    lc.clearDisplay(0);                                             //７セグメントLED　表示をクリア
    //準備動作
    ussRead(US1);                                                   //前方センサー検知
    ussRead(US2);                                                   //右側センサー検知
    delay(500);
}

void loop(){
    int dist1 = ussRead(US1);
    int dist2 = ussRead(US2);

    if (dist1 > 6 && dist2 <= 10){                                  //前が開けていて、右側の壁まで10センチ以下のとき
        omniBot.move(0, 20, constrain(( dist2 - 8 ) * 3, -10, 10)); //壁から8センチを保って前進
        //【解説】
        //constrain(A,B,C)は「Aの数値」を「Bの数値」から「Cの数値」の間に抑えこむ関数。
        //だから、ここでは、A<-10のときには A=-10、A>10のときにはA=10となる。
        //つまり、(dist2-8)*3の計算結果を-10から10の間に抑えこみ、ロボットの旋回速度としている。
        //この書き方では、壁との距離に応じて旋回速度が変化するうえ、
        //Case2のプログラムでの１２行をたった１行で書くことができます。
    }
    else{                                                           //前が開けていない、または、右の壁までの距離が10センチより遠いとき
        omniBot.move(0, 0, 0);                                      //ロボットを停止
    }

    delay(100);
}
