//-----------------------------------------------------------------------
// パターン１：　前方(US1)と右側(US2)に壁
// US1に反応がなくなるまで左に旋回する
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

#include <RPomniDirect.h>
#include <RPlib.h>
#include <LedControl.h>

LedControl lc = LedControl(11, 13, 1);                              //７セグメントLEDを使うためのオマジナイ
RPomniDirect omniBot(1.0f, 1.0f, 1.0f, 0.0, MC3, MC1, MC2);         //以前の調整データを使ってね

void setup(){
    lc.shutdown(0, false);                                          //７セグメントLED　リセット
    lc.setIntensity(0, 4);                                          //７セグメントLED　色の濃さ設定
    lc.clearDisplay(0);                                             //７セグメントLED　表示をクリア
    //準備動作
    ussRead(US1);                                                   //前方センサー検知
    ussRead(US2);                                                   //右側センサー検知
    delay(500);
}

void loop(){
    int dist1 = ussRead(US1);                                       //前方センサー検知
    int dist2 = ussRead(US2);                                       //右側センサー検知

    if (dist1 <= 6 && dist2 <= 10){                                 //もし前方の壁まで6センチ以下かつ、右の壁まで10センチ以下なら
        omniBot.move(0, 0, -20);                                    //ロボットは左回転
        while (ussRead(US1) < 20 || ussRead(US2) > 10)             //前方が20センチ以上開けていて右10センチの範囲に壁が見えるまで回転を継続
        delay(600);                                                 //***調整箇所*** ロボットが正面を向くように値を調整します。
    }
    else{                                                           //それ以外のとき
        omniBot.move(0, 0, 0);                                      //停止
    }
    lc.setDec(0, dist1);                                            //前方超音波距離センサーの値を表示する
    delay(100);
}
