//-----------------------------------------------------------------------
// 輝度を取り込んで表示する
// 音とLEDのプログラム合体
// 関数版
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

#include <ColorSensor.h>
#include <LedControl.h>
#include <RPlib.h>
#include <Tone.h>
Tone tone1;

//曲データ2
char *sound2  = "M2A:d=4,o=6,b=180:16g,16c7,16f7,16p,16c7,16d7,16g7,16p,16g,16c7,16d7,16f7,16g7,16d7,16c7,16d7";
int rx[]      = {0, 1, 2, 3, 3, 3, 3, 2, 1, 0, 0, 0};
int ry[]      = {1, 1, 1, 1, 2, 5, 0, 0, 0, 0, 4, 6};

LedControl lc = LedControl(11, 13, 1);        //７セグメントLEDを使うためのオマジナイ

void setup(){
    tone1.begin(D2);                          //D2にスピーカーを接続

    lc.shutdown(0, false);                    //７セグメントLEDをリセット
    lc.setIntensity(0, 8);                    //色の濃さ
    lc.clearDisplay(0);                       //表示クリア

    ColorSensor.begin(4000, 0);               //カラーセンサーの積分時間を指定 x0.1[ms]　 値が大きいほどセンサー値の精度が良くなるが、そのぶん時間がかかる　6000で600[ms] 最大 6144
}

int clear;
int i;
void loop(){
    if (ColorSensor.colorRead()){
        clear = ColorSensor.colorClear();     //輝度を取り込む
    }
    if(clear < 500){                          //計測したデータ
        //陰気スポット発見
        calmfunc();                           //自作のオリジナル命令(関数)
    }

    delay(100);
}

//---------------------------------
//-------------------- オリジナル関数
void calmfunc(){                              //名前は好きに決めることができる(※すでに用意されている名前でなければ)
    lc.clearDisplay(0);                       //表示クリア
    tone1.play_rtttl(sound2);                 //sound2の曲を流す
    for(i = 0; i < 12; i++){
        lc.setLed(0, rx[i], ry[i], HIGH);
        delay(100);
        lc.setLed(0, rx[i], ry[i], LOW);
    }
}
