//-----------------------------------------------------------------------
// 輝度を取り込んで表示する
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

#include <ColorSensor.h>
#include <LedControl.h>

LedControl lc = LedControl(11, 13, 1);    //７セグメントLEDを使うためのオマジナイ

void setup(){
    lc.shutdown(0, false);                //７セグメントLEDをリセット
    lc.setIntensity(0, 8);                //色の濃さ
    lc.clearDisplay(0);                   //表示クリア

    ColorSensor.begin(4000, 0);           //カラーセンサーの積分時間を指定 x0.1[ms]　 値が大きいほどセンサー値の精度が良くなるが、そのぶん時間がかかる　6000で600[ms] 最大 6144
}

int clear;
void loop(){
    if (ColorSensor.colorRead()){
        clear = ColorSensor.colorClear(); //輝度を取り込む
        lc.setDec(0, clear);              //取り込んだ輝度をLEDに表示する
    }

    delay(100);
}
