//-----------------------------------------------------------------------
//  STEP4
//前後のセンサーに同時に反応したら横に逃げる
//
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
#include <RPomniDirect.h>
#include <RPlib.h>
#include <LedControl.h>
//１、２、３のモーター番号通りに組んであれば以前使った調整値がそのまま使えます。
//わからなくなってしまった場合はもう一度アジャストプログラムを走らせる必要があります。
RPomniDirect omniBot(1.0f, 1.0f, 1.0f, 50.0f);
LedControl lc = LedControl(11, 13, 1);             //おまじない

void setup(){
    lc.shutdown(0, false);                         //７セグLED　リセット
    lc.setIntensity(0, 4);                         //７セグLED　色の濃さ設定
    lc.clearDisplay(0);                            //７セグLED　表示をクリア
    //準備動作
    ussRead(US1);                                  //前センサ検出
    ussRead(US2);                                  //後ろセンサ検出
    delay(500);
}

int d1 = 0;
int d2 = 0;
void loop(){
    d1 = ussRead(US1);                             //センサーUS1(前方)検知
    d2 = ussRead(US2);                             //センサーUS2(後方)検知

    omniBot.move(0, 0, 30);                        //回転する

    if (d1 > 5 && d2 > 5 && d1 <= 15 && d2 <= 15){ //前方距離d1か後方距離d2が15センチ以内
        omniBot.move(30, 0, 0);                    //横に逃げる
        delay(3000);                               //3秒間逃げる
    }
    else if (d1 > 5 && d1 <= 15){                  //前方距離D1が15センチ以内
        omniBot.move(0, -500 / d1, 0);             //後ろに逃げる
        delay(1000);                               //1秒間逃げる
    }
    else if (d2 > 5 && d2 <= 15){                  //後方距離d2が15センチ以内
        omniBot.move(0, 500 / d2, 0);              //前に逃げる
        delay(1000);                               //1秒間逃げる
    }
    lc.setDec(0, min(d1, d2));                     //距離が小さい方の超音波センサーの値を表示する
    delay(50);
}
