//-----------------------------------------------------------------------
// 完成版
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
#include <RPomniDirect.h>
#include <RPlib.h>
#include <LedControl.h>
//１、２、３のモータ番号通りに組んであれば以前使った調整値がそのまま使えます。
//わからなくなってしまった場合はもう一度アジャストプログラムを走らせる必要があります。
RPomniDirect omniBot(1.0f,1.0f,1.0f,50.0f);
LedControl lc = LedControl(11,13,1);  //おまじない

void setup(){
    lc.shutdown(0,false);             //７セグLED　リセット
    lc.setIntensity(0,4);             //７セグLED　色の濃さ設定
    lc.clearDisplay(0);               //７セグLED　表示をクリア
//準備動作
    ussRead(US1);                     //前センサ検出
    ussRead(US2);                     //後ろセンサ検出
    delay(500);
}

int d1 = 0;
int d2 = 0;
int spd,t;
void loop(){
    d1 = ussRead(US1);                //前センサ検出
    d2 = ussRead(US2);                //後ろセンサ検出

    omniBot.move(0,0,30);             //旋回する

    if(d1 <= 15 && d2 <= 15){         //d1,d2距離が15センチ以内
        omniBot.move(30,0,0);         //右に逃げる(進む)
        delay(1000);                  //1秒逃げる
    }
    else if(d1 <= 15){                //d１距離が15センチ以内
        spd = -500 / d1;
        for(t = 0; t < 300; t++){
            d2 = ussRead(US2);        //後ろセンサ検出
            omniBot.move(0,spd,0);    //後進で逃げる
            if(d2 <= 15){
                omniBot.move(0,0,30); //旋回する
                delay(1000);          //1秒旋回
            }
            if(d1 < 15){              //後ろに反応したらスピードアップ
                spd -= 5;
                delay(100);
            }
            delay(10);
        }
    }
    else if(d2 <= 15){                //d2距離が15センチ以内
        spd = 500 / d2;
        for(t = 0; t < 300; t++){
            d1 = ussRead(US1);        //前センサ検出
            omniBot.move(0,spd,0);    //後進で逃げる
            if(d1 <= 15){
                omniBot.move(0,0,30); //旋回する
                delay(1000);          //1秒旋回
            }
            if(d2 <= 15){             //直進方向後ろ反応したらスピードアップ
                spd += 5;
                delay(100);
            }

            delay(10);
        }
    }

    lc.setDec(0,min(d1,d2));          //距離が小さい方の超音波センサーの値を表示する
    delay(50);
}
