//-----------------------------------------------------------------------
// カラーシーカー完成
// 青色
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
#include <RPomniDirect.h>
#include <RPlib.h>
#include <ColorSensor.h>
#include <LedControl.h>
//１、２、３のモーター番号通りに組んであれば以前使った調整値がそのまま使えます。
//わからなくなってしまった場合はもう一度アジャストプログラムを走らせる必要があります。
RPomniDirect omniBot(1.0f, 1.0f, 1.0f, 50.0f);
LedControl lc = LedControl(11, 13, 1);                //おまじない

void setup(){
    lc.shutdown(0, false);                            //７セグLED　リセット
    lc.setIntensity(0, 4);                            //７セグLED　色の濃さ設定
    lc.clearDisplay(0);                               //７セグLED　表示をクリア
    ColorSensor.begin(4000, 0);                       // カラーセンサの積分時間を指定 x0.1[ms]　 値が大きいほどセンサ値の精度が良くなるが、そのぶん時間がかかる　6000で600[ms] 最大 6144
    for(int i = 4; i < 8; i++) ColorSensor.ledOn(i);  //照明用LEDの点灯
//準備動作
    ussRead(US1);                                     //前センサ検出
    ussRead(US2);                                     //後ろセンサ検出
    delay(500);
}

int d1 = 0;
int d2 = 0;
void loop(){
    d1 = ussRead(US1);                                //前センサ検出
    d2 = ussRead(US2);                                //後ろセンサ検出

    omniBot.move(0, -20, 0);                          //後進する
    if (d2 <= 5){
        omniBot.move(0, 0, 0);                        //ストップ

        if (ColorSensor.colorRead()){                 //色センサーの読み込み
            word clear = ColorSensor.colorClear();    //色センサの数値初期化

            word red   = ColorSensor.colorRed();      //色センサの赤要素検出
            word green = ColorSensor.colorGreen();    //色センサの緑要素検出
            word blue  = ColorSensor.colorBlue();     //色センサの青要素検出

            ColorSensor.convertHSV(red, green, blue); //RGBデータをHSVデータに変更する
            word h = ColorSensor.convertH();
            word s = ColorSensor.convertS();
            word v = ColorSensor.convertV();

            ColorSensor.convertRGB(h);                //HSVをRGBに変更
            byte ledR = ColorSensor.convertRed();
            byte ledG = ColorSensor.convertGreen();
            byte ledB = ColorSensor.convertBlue();

            lc.setDec(0, h);                          //H値を７セグLEDで表示する
            if (h >= 200){                            //青色を探す 見つければLEDを光らせて終了する
                omniBot.move(0, 0, 0);                //ストップ  終了
                ColorSensor.ledRGB(ledR, ledG, ledB); //フルカラーLEDで表現する
            }
            else{                                     //違った場合
                //for(int i=4;i<8;i++) ColorSensor.ledOff(i);  //照明用LEDの消灯
                ColorSensor.ledRGB(0, 0, 0);
                omniBot.move(0, 0, 30);               //旋回する
                delay(750);
            }
        }
    }

    //  lc.setDec(0,min(d1,d2)); //距離が小さい方の超音波センサーの値を表示する
    delay(100);
}
