//-----------------------------------------------------------------------
// 超音波距離センサーに(３０センチ)反応があったら前進する
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
#include <RPomniDirect.h>
#include <RPlib.h>
#include <LedControl.h>
//１、２、３のモータ番号通りに組んであれば以前使った調整値がそのまま使えます。
//わからなくなってしまった場合はもう一度アジャストプログラムを走らせる必要があります。
RPomniDirect omniBot(1.0f,1.0f,1.0f,50.0f);
LedControl lc = LedControl(11,13,1); //おまじない

void setup(){
    lc.shutdown(0,false);            //７セグLED　リセット
    lc.setIntensity(0,4);            //７セグLED　色の濃さ設定
    lc.clearDisplay(0);              //７セグLED　表示をクリア
}

int d = 0;
void loop(){
    delay(100);
    lc.clearDisplay(0);              //７セグLED　表示をクリア
    d = ussRead(US1);                //センサー検出

    if(d <= 30){                     //３０センチ以下の場合
        omniBot.move(0,30,0);        //前進する
    }
    else{
        omniBot.move(0,0,0);         //停止する
    }

    lc.setDec(0,d);                  //超音波センサーの値を表示する
    delay(100);
}
