//-----------------------------------------------------------------------
//カラーセンサのテスト
//黄色を発見したら後進する
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

#include <RPomniDirect.h>
#include <RPlib.h>
#include <ColorSensor.h>
#include <LedControl.h>

//１、２、３のモータ番号通りに組んであれば以前使った調整値がそのまま使えます。
//わからなくなってしまった場合はもう一度アジャストプログラムを走らせる必要があります。
RPomniDirect omniBot(1.0f,1.0f,1.0f,50.0f);
LedControl lc = LedControl(11,13,1);                  //７セグを使うためのオマジナイ

void setup(){
    lc.shutdown(0,false);                             //７セグをリセット
    lc.setIntensity(0,8);                             //色の濃さ
    lc.clearDisplay(0);                               //表示クリア
    ColorSensor.begin(1000, 0);                       // カラーセンサの積分時間を指定 x0.1[ms]　 値が大きいほどセンサ値の精度が良くなるが、そのぶん時間がかかる　6000で600[ms] 最大 6144
    for(int i = 4; i < 8; i++) ColorSensor.ledOn(i);  //照明用LEDの点灯
}

void loop(){
    if (ColorSensor.colorRead()){                     //色センサーの読み込み
        word clear = ColorSensor.colorClear();        //色センサの数値初期化

        word red   = ColorSensor.colorRed();          //色センサの赤要素検出
        word green = ColorSensor.colorGreen();        //色センサの緑要素検出
        word blue  = ColorSensor.colorBlue();         //色センサの青要素検出

        ColorSensor.convertHSV(red, green, blue);     //RGBデータをHSVデータに変更する
        word h = ColorSensor.convertH();
        word s = ColorSensor.convertS();
        word v = ColorSensor.convertV();

        ColorSensor.convertRGB(h);                    //HSVをRGBに変更
        byte ledR = ColorSensor.convertRed();
        byte ledG = ColorSensor.convertGreen();
        byte ledB = ColorSensor.convertBlue();

        if(s > 7){                                    // S彩度が高いか？
            // ColorSensor.ledRGB(ledR, ledG, ledB);//フルカラーLEDで表現する
        }
        else {
            ColorSensor.ledRGB(0, 0, 0);
        }
        lc.setDec(0,h);                               //H値を７セグLEDで表示する

        if(h >= 40 && h <= 80){                       //黄色を探す
            omniBot.move(0,-30,0);                    //後進する
        }
        else{
            omniBot.move(0,0,0);                      //止める
        }

        delay(100);
    }
}
