//-----------------------------------------------------------------------
// 超音波センサーに(30センチ)反応があったら前進する。後進する。
// チャレンジ課題解答例
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
#include <RPomniDirect.h>
#include <RPlib.h>
#include <LedControl.h>
//１、２、３のモーター番号通りに組んであれば以前使った調整値がそのまま使えます。
//わからなくなってしまった場合はもう一度アジャストプログラムを走らせる必要があります。
RPomniDirect omniBot(1.0f,1.0f,1.0f,50.0f);
LedControl lc = LedControl(11,13,1); //おまじない

void setup(){
    lc.shutdown(0,false);            //７セグLED　リセット
    lc.setIntensity(0,4);            //７セグLED　色の濃さ設定
    lc.clearDisplay(0);              //７セグLED　表示をクリア
}

int d1   = 0;                        //前のセンサーデータ変数
int d2   = 0;                        //後ろのセンサーデータ変数
int sign = 1;                        //ロボットの進行方向を決める変数、最初は１で前進、−１になると後退
void loop(){
    d1 = ussRead(US1);               //前センサー検出
    d2 = ussRead(US2);               //後ろセンサー検出

    if(d1 <= 30 || d2 <= 30){        //前後センサーのどちらかの検出距離が30センチ以下の場合
        sign = -1 * sign;            //方向の正負を切り替える
        omniBot.move(0,30 * sign,0); //ロボットを動かす
        delay(1000);
    }

    if(d1 < d2){                     //比較して距離の小さい方を表示する
        lc.setDec(0,d1);             //超音波距離センサー1の値を表示する
    }
    else{
        lc.setDec(0,d2);             //超音波距離センサー2の値を表示する
    }
    delay(100);
}
