
//-----------------------------------------------------------------------
// セミオートコントロールカスタム
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

#include <RPlib.h>
#include <VarSpeedServo.h>
#include <ArmRobot.h>
#include <PS2X_lib.h>

PS2X ps2x;
ArmRobot armBot;

void setup(){
    pinMode(D3,INPUT_PULLUP);                     //スタートボタンの設定
    ps2x.config_gamepad(13,11,10,12, true, true); //コントローラーを使うときのオマジナイ

    while(!digitalRead(D3));
    armBot.setup(0.0,0.0,0.0,0.0);                //調整値(servoR,servoL,servoROT,servoGRIPの順)
    delay(3000);
    while(!digitalRead(D3));
    armBot.setServoSpeed(SERVO_R,   10);
    armBot.setServoSpeed(SERVO_L,   10);
    armBot.setPosition(100,0,0);
    delay(1000);
    armBot.setServoSpeed(SERVO_R,   30);
    armBot.setServoSpeed(SERVO_L,   30);
    armBot.setServoSpeed(SERVO_ROT,   30);
}

int z,x,r;
double zz = 0,xx = 100,rr = 0;

void loop(){
    ps2x.read_gamepad();                          //コントローラーから値を読み取る

    z = ps2x.Analog(PSS_LY);                      //アナログ左スティック上下
    x = ps2x.Analog(PSS_RY);                      //アナログ右スティック上下
    r = ps2x.Analog(PSS_RX);                      //アナログ右スティック左右

    zz += (double)( z - 1 ) / 80;                 
    xx += (double)( x - 1 ) / 80;                 
    rr += (double)( r ) / 160;                   

    //動きすぎないように制限をかける
    zz = constrain(zz,-180,150);
    xx = constrain(xx,0,210);
    rr = constrain(rr,-90,90);

    armBot.setPosition(xx,zz,rr);

    if(ps2x.Button(PSB_PAD_UP)){                  //もし十字ボタンの上がおされたら
        armBot.gripperCatch();                    //ハンドを閉じる
    }

    if(ps2x.Button(PSB_PAD_DOWN)){                //もし十字ボタンの下がおされたら
        armBot.gripperRelease();                  //ハンドを開く
    }

    delay(10);
}
