
//-----------------------------------------------------------------------
// UFOキャッチャー
// コントローラーのスタートボタンでスタート
// ◯ボタンでx座標を決定しXボタンでy座標を決定する
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

#include <RPlib.h>
#include <VarSpeedServo.h>
#include <ArmRobot.h>
#include <PS2X_lib.h>

PS2X ps2x;
ArmRobot armBot;

void setup(){
    pinMode(D3,INPUT_PULLUP);                     //スタートボタンの設定
    ps2x.config_gamepad(13,11,10,12, true, true); //コントローラーを使うときのオマジナイ

    while(!digitalRead(D3));
    armBot.setup(0.0,0.0,0.0,0.0);                //調整値(servoR,servoL,servoROT,servoGRIPの順)
    delay(1000);
    while(!digitalRead(D3));
    armBot.setServoSpeed(SERVO_R,   10);
    armBot.setServoSpeed(SERVO_L,   10);
    armBot.setPosition(100,0,0);
    delay(1000);
    armBot.setServoSpeed(SERVO_R,   30);
    armBot.setServoSpeed(SERVO_L,   30);
    armBot.setServoSpeed(SERVO_ROT,   30);

    ps2x.read_gamepad();                          //コントローラーから値を読み取る
}

double x = 0;
double y = 0;
double d = 1;

void loop(){
    while(1){
        ps2x.read_gamepad();                      //コントローラーから値を読み取る
        ps2x.read_gamepad();                      //コントローラーから値を読み取る
        ps2x.read_gamepad();                      //コントローラーから値を読み取る

        if(ps2x.Button(PSB_START)) break;
        delay(30);
    }

    armBot.setXYZ(0,0,50);
    armBot.gripperRelease();
    delay(1000);

    while(1){
        x += d;

        if(x <= -50) d = 1;
        if(x >= 75) d = -1;

        armBot.setXYZ(x,0,50);
        ps2x.read_gamepad();                      //コントローラーから値を読み取る
        if(ps2x.Button(PSB_RED)) break;
        delay(30);
    }

    while(1){
        y += d;

        if(y <= -75) d = 1;
        if(y >= 75) d = -1;

        armBot.setXYZ(x,y,50);
        ps2x.read_gamepad();                      //コントローラーから値を読み取る
        if(ps2x.Button(PSB_BLUE)) break;
        delay(30);
    }

    armBot.setXYZ(x,y,20);
    delay(1000);
    armBot.gripperCatch();
    delay(1000);
    armBot.setXYZ(x,y,80);
    delay(1000);
    armBot.setXYZ(-50,-75,80);
    delay(1000);
    armBot.gripperRelease();
    delay(1000);

    delay(10);
}
