
//-----------------------------------------------------------------------
// ブロックの搬送
// (アームの正面の初期位置0cmと10cmにブロックを置いてから実行)
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

#include <RPlib.h>
#include <VarSpeedServo.h>
#include <ArmRobot.h>

ArmRobot armBot;

void setup(){
    pinMode(D3,INPUT_PULLUP);              //スタートボタンの設定

    while(!digitalRead(D3));
    armBot.setup(0.0,0.0,0.0,0.0);         //調整値(servoR,servoL,servoROT,servoGRIPの順)
    delay(1000);
    while(!digitalRead(D3));
    armBot.setServoSpeed(SERVO_R,   10);
    armBot.setServoSpeed(SERVO_L,   10);
    armBot.setPosition(100,100,0);
    delay(1000);
    armBot.setServoSpeed(SERVO_R,   30);
    armBot.setServoSpeed(SERVO_L,   30);
    armBot.setServoSpeed(SERVO_ROT,   30);
    armBot.setXYZ(0,0,100);
}

void loop(){
    while(!digitalRead(D3));               //スタート待ち

    armBot.gripperRelease();               //ハンドを開く
    delay(1000);

    armBot.setXYZ(0,0,0);                  //ブロックを拾いに行く
    delay(2000);

    armBot.gripperCatch();                 //ハンドを閉じる
    delay(1000);

    armBot.setXYZ(0,0,100);                //z100の座標までブロックを持ち上げる
    delay(2000);

    armBot.setXYZ(100,0,100);              //x100,z100の座標に移動
    delay(2000);

    armBot.setXYZ(100,0,50);               //x100,z50の座標に移動
    delay(2000);

    armBot.gripperRelease();               //ハンドを開く
    delay(1000);

    armBot.setXYZ(100,0,100);              //x100,z100の座標に移動
    delay(2000);

    armBot.setXYZ(0,0,100);                //x0,z100の初期座標に移動
    delay(2000);
}
