//-----------------------------------------------------------------------
// セミオートコントロール
// 計算をして手先位置をコントロール
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
//ライブラリを読み込む
#include <RPlib.h>
#include <VarSpeedServo.h>
#include <ArmRobot.h>
#include <PS2X_lib.h>

PS2X ps2x;                                        //コントローラーに名前をつける
ArmRobot armBot;                                  //アームロボットを使うときのオマジナイ

void setup(){
    pinMode(D3,INPUT_PULLUP);                     //D3に接続されたタッチセンサーを読み取る
    ps2x.config_gamepad(13,11,10,12, true, true); //コントローラーを使うときのオマジナイ

    while(!digitalRead(D3));
    armBot.setup(0.0,0.0,0.0,0.0);                //調整値(servoR,servoL,servoROT,servoGRIPの順)
    delay(3000);
    while(!digitalRead(D3));
    armBot.setServoSpeed(SERVO_R,   10);          //サーボモーターの速度を調整(1-255)
    armBot.setServoSpeed(SERVO_L,   10);          //サーボモーターの速度を調整(1-255)
    armBot.setPosition(100,0,0);
    delay(1000);
    armBot.setServoSpeed(SERVO_R,   0);           //サーボモーターの速度を調整(1-255)
    armBot.setServoSpeed(SERVO_L,   0);           //サーボモーターの速度を調整(1-255)
}

int z,x,r;
double zz = 0,xx = 100,rr = 0;

void loop(){
    ps2x.read_gamepad();        //コントローラーから値を読み取る

    z = ps2x.Analog(PSS_LY);    //アナログ左スティック上下
    x = ps2x.Analog(PSS_RY);    //アナログ右スティック上下
    r = ps2x.Analog(PSS_RX);    //アナログ右スティック左右

    zz += (double)( z - 1 ) / 80;
    xx += (double)( x - 1 ) / 80;
    rr += (double)( r ) / 160;

    //動きすぎないように制限をかける
    zz = constrain(zz,0,120);
    xx = constrain(xx,80,250);
    rr = constrain(rr,-60,60);

    armBot.setPosition(xx,zz,rr);


    if(ps2x.Button(PSB_PAD_UP)){        //もし十字ボタンの上が押されたら
        armBot.gripperCatch();          //ハンドを閉じる
    }

    if(ps2x.Button(PSB_PAD_DOWN)){      //もし十字ボタンの下が押されたら
        armBot.gripperRelease();        //ハンドを開く
    }


    delay(10);
}
