//-----------------------------------------------------------------------
// サーボモーターのテスト(write命令)
// 180段階で制御
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
//ライブラリの読み込み
#include <RPlib.h>
#include <Servo.h>
#define ORIGIN 90
#define RANGE 60

Servo servo;        ////サーボモーターを使うときのオマジナイ(servoと名づける)


void setup(){
    pinMode(D3,INPUT_PULLUP); //D3にタッチセンサーを接続
    while(!digitalRead(D3));  //D3に接続されたタッチセンサーを読み込み
    servo.attach(S0);         //サーボモーターをS0に接続
    delay(500);
}

void loop(){
    while(!digitalRead(D3)); //D3に接続されたタッチセンサーを読み取る

    for(double deg = 0; deg < RANGE / 2; deg += 0.1){
        servo.write((int)deg + ORIGIN);
        delay(5);
    }

    for(double deg = RANGE / 2; deg >= -RANGE / 2; deg -= 0.1){
        servo.write((int)deg + ORIGIN);
        delay(5);
    }

    for(double deg = -RANGE / 2; deg <= 0; deg += 0.1){
        servo.write((int)deg + ORIGIN);
        delay(5);
    }
}
