//-----------------------------------------------------------------------
// タイヤをつかんで手元まで持ってくる
// アームの初期位置の先端から100mmのところのものがターゲット
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
//ライブラリを読み込む
#include <RPlib.h>
#include <VarSpeedServo.h>
#include <ArmRobot.h>

ArmRobot armBot;                         //アームロボットを使うときのオマジナイ

void setup(){
    pinMode(D3, INPUT_PULLUP);           //D3にタッチセンサーを接続

    while (!digitalRead(D3));            //D3に接続されたタッチセンサーを読み取る
    armBot.setup(0.0, 0.0, 0.0, 0.0);    //調整値(servoR,servoL,servoROT,servoGRIPの順)
    delay(3000);
    while (!digitalRead(D3));            //D3に接続されたタッチセンサーを読み取る
    armBot.setServoSpeed(SERVO_R,   10); //サーボモーターの速度調整(1-255)
    armBot.setServoSpeed(SERVO_L,   10); //サーボモーターの速度調整(1-255)
    armBot.setPosition(80, 0, 0);        //アームロボットの動作開始位置
    delay(2000);
}

int z, x, r;

void loop(){
    while (!digitalRead(D3));            //D3に接続されたタッチセンサーを読み取る

    armBot.gripperRelease();             //ハンドを開く
    delay(2000);
    armBot.setPosition(80, 100, 0);      //アームの先を100ミリ上げる
    delay(5000);
    armBot.setPosition(150, 100, 0);     //アームの先を100ミリ伸ばす
    delay(5000);
    armBot.setPosition(150, 30, 0);      //アームの先を70ミリ下げる
    delay(5000);
    armBot.gripperCatch();               //ハンドを閉じる
    delay(2000);
    armBot.setPosition(150, 100, 0);     //アームの先を70ミリ上げる
    delay(5000);
    armBot.setPosition(80, 100, 0);      //アームの先を100ミリたたむ
    delay(5000);
    armBot.setPosition(80, 30, 0);       //アームの先を70ミリ下げる
    delay(5000);
    armBot.gripperRelease();             //ハンドを開く
    delay(2000);
}
