//-----------------------------------------------------------------------
// サーボモーター(S0)のモーション確認テスト
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
//ライブラリを読み込む
#include <RPlib.h>
#include <VarSpeedServo.h>

#define ORIGIN 90      //原点位置
#define RANGE 30
VarSpeedServo myservo; //サーボモーターを使うときのオマジナイ(myservoと名づける)

int pos = 0;           //変数intをposという名前で使う(はじめは0)

void setup(){
    myservo.attach(S0, SERVO_MG995_MIN, SERVO_MG995_MAX); //myservoと名づけたモーターをS0に接続

    for (pos = 0; pos >= -RANGE; pos -= 1){                //0度から-RANGE度まで(1度ずつ)
        myservo.write(pos + ORIGIN);                      //writeで角度を指定(変数posの値で動く)
        delay(50);                                        //50ミリ秒待つ
    }
}

void loop(){
    for (pos = -RANGE; pos < RANGE; pos += 1){  //-RANGE度からRANGE度まで(1度ずつ)
        myservo.write(pos + ORIGIN);            //writeで角度を指定(変数posの値で動く)
        delay(50);                              //50ミリ秒待つ
    }
    for (pos = RANGE; pos >= -RANGE; pos -= 1){ //RANGE度から-RANGE度まで(1度ずつ)
        myservo.write(pos + ORIGIN);            //writeで角度を指定(変数posの値で動く)
        delay(50);                              //50ミリ秒待つ
    }
}
