//-----------------------------------------------------------------------
// コントローラーでアームロボットを動かす
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
//ライブラリを読み込む
#include <RPlib.h>
#include <VarSpeedServo.h>
#include <PS2X_lib.h>

#define ORIGIN 90         //原点位置
#define SERVOR_MIN 50     //サーボモーター右 最小角度50
#define SERVOR_MAX 100    //サーボモーター右 最大角度100
#define SERVOL_MIN 50     //サーボモーター左 最小角度50
#define SERVOL_MAX 140    //サーボモーター左 最大角度140
#define SERVOROT_MIN 0    //サーボモーターベース 最小角度0
#define SERVOROT_MAX 180  //サーボモーターベース 最大角度180
#define SERVOGRIP_MIN 55  //マイクロサーボモーター 最小角度55
#define SERVOGRIP_MAX 125 //マイクロサーボモーター 最大角度125


VarSpeedServo servoR;    //サーボモーターを使うときのオマジナイ(servoRと名づける)
VarSpeedServo servoL;    //サーボモーターを使うときのオマジナイ(servoLと名づける)
VarSpeedServo servoROT;  //サーボモーターを使うときのオマジナイ(servoROTと名づける)
VarSpeedServo servoGRIP; //サーボモーターを使うときのオマジナイ(servoGRIPと名づける)

PS2X ps2x;               //コントローラーに名前をつける

void setup(){
    pinMode(D3, INPUT_PULLUP);
    ps2x.config_gamepad(13, 11, 10, 12, true, true);       //コントローラーを使うときのオマジナイ
    Serial.begin(9600);                                    //シリアル通信を使うときのオマジナイ

    while (!digitalRead(D3));                              //D3に接続されたタッチセンサーを読み取る

    servoR.attach(S0, SERVO_MG995_MIN, SERVO_MG995_MAX);   //servoRと名づけたモーターをS0に接続
    delay(500);
    servoL.attach(S1, SERVO_MG995_MIN, SERVO_MG995_MAX);   //servoLと名づけたモーターをS1に接続
    delay(500);
    servoROT.attach(S2, SERVO_MG995_MIN, SERVO_MG995_MAX); //servoROTと名づけたモーターをS2に接続
    delay(500);
    servoGRIP.attach(S3, SERVO_SG90_MIN, SERVO_SG90_MAX);  //servoGRIPと名づけたモーターをS3に接続
}

int rud = 0, lud = 0, rlr = 0, llr = 0;              //アナログスティックRLの上下左右
int angR = 90, angL = 90, angROT = 90, angGRIP = 90; //それぞれのサーボモーターの角度

void loop(){

    ps2x.read_gamepad();        //コントローラーから値を読み取る

    lud = ps2x.Analog(PSS_LY);  //アナログ左スティック上下
    rud = ps2x.Analog(PSS_RY);  //アナログ右スティック上下
    rlr = ps2x.Analog(PSS_RX);  //アナログ右スティック左右
    llr = ps2x.Analog(PSS_LX);  //アナログ左スティック左右

    angR += ( rud - 1 ) / 80;
    angL += ( lud - 1 ) / 80;
    angROT += ( rlr - 1 ) / 80;
    angGRIP += ( llr ) / 80;

    angR = constrain(angR, SERVOR_MIN, SERVOR_MAX);
    angL = constrain(angL, SERVOL_MIN, SERVOL_MAX);
    angROT = constrain(angROT, SERVOROT_MIN, SERVOROT_MAX);
    angGRIP = constrain(angGRIP, SERVOGRIP_MIN, SERVOGRIP_MAX);

    servoR.write(angR);
    servoL.write(angL);
    servoROT.write(angROT);
    servoGRIP.write(angGRIP);

    delay(50);
}
