//-----------------------------------------------------------------------
// オムニホイールロボットをコントローラーで操縦する
// 調整用プログラム
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
#include <RPomniDirect.h>
#include <RPlib.h>
#include <PS2X_lib.h>

//おまじない
RPomniDirect omniBot(1.0f, 1.0f, 0.9f, 10.0f);       //オムニホイール調整用パラメータ
PS2X ps2x;

float xx, yy;                                        //移動速度変数

void setup(){
    ps2x.config_gamepad(13, 11, 10, 12, true, true); //おまじない（ピン設定）
}

void loop(){
    ps2x.read_gamepad();                             //コントローラーから値を読み込む

    if(ps2x.Button(PSB_RED)){                        //右ななめ前へ移動
        omniBot.move(64 * cos(PI * 1 / 6), 64 * sin(PI * 1 / 6), 0);
    }
    else if(ps2x.Button(PSB_BLUE)){
        omniBot.move(64, 0, 0);                      //右へ移動
    }
    else if(ps2x.Button(PSB_GREEN)){
        omniBot.move(0, 64, 0);                      //前へ移動
    }
    else{
        omniBot.move(0, 0, 0);
    }
    delay(10);
}
