//-----------------------------------------------------------------------
// 超音波距離センサー搭載ロボット　落下回避
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

//ライブラリを取り込む
#include <Sprite.h>
#include <Matrix.h>
#include <RPlib.h>

#define  NEUTRAL  0
#define  LEFT   1
#define  RIGHT  2
#define  FORWARD  3
#define  BACKWARD  4

int gCmdTmp     = NEUTRAL;

Matrix myMatrix = Matrix(11, 13, 1); //マトリクスLEDを使うときのオマジナイ
RPmotor mc1(MC1);
RPmotor mc2(MC2);

void setup(){
    myMatrix.setBrightness(3);       //マトリクスLEDの明るさを設定(0−8)
    myMatrix.clear();
}

void loop(){
    static int DIV = 1;              //一けたに収まりそうな数にする分母
    int cmd        = NEUTRAL;
    int sub;                         //変数intをsubという名前で使う
    int dist1;                       //変数intをdist1という名前で使う
    int dist2;                       //変数intをdist2という名前で使う
    int dispNum = 0;                 //変数intをdispNumという名前で使う（初期値は0）

    dist1 = ussRead(US1);            //US1の距離データを変数dist1に入れる
    dist2 = ussRead(US2);            //US2の距離データを変数dist2に入れる

    if (dist1 > 99) dist1 = 99;
    if (dist2 > 99) dist2 = 99;

    dist1 /= DIV;
    dist2 /= DIV;

    if (dist2 > 3){
        //机がなければ回転する
        mc1.rotate(50);
        mc2.rotate(50);
        delay(1000);                 //一秒間待つ
    }
    else{
        //机があれば前進する
        mc1.rotate(-50);
        mc2.rotate(50);
    }

    //-------------- ここから先は触らない--------------------------

    // 以下、距離表示用

    // 左右回転の命令
    if (abs(sub) <= 1){
        cmd = NEUTRAL;               // 差分が小さかったら動かない
    }
    else if (dist1 > dist2){
        cmd = RIGHT;                 // 右のセンサーが近いので右に回転
    }
    else if (dist1 < dist2){
        cmd = LEFT;                  // 左のセンサーが近いので左に回転
    }

    dispNum = abs(sub);
    // 以下、マトリクスLED表示用の処理
    myMatrix.putd2(0, 0, dispNum);   //マトリクスLEDに2けたの数字を表示

    // 移動方向の表示
    // 方向の変更ありの場合
    if (cmd != gCmdTmp){
        // クリア(処理速度節約のため直接点灯OFF)  myMatrix.clear();←マトリクスLEDの表示を消す
        if (gCmdTmp == LEFT){
            myMatrix.write(0, 6, 0); // 左回転移動の表示を消す
            myMatrix.write(1, 6, 0);
        }
        if (gCmdTmp == RIGHT){
            myMatrix.write(6, 6, 0); // 右回転移動の表示を消す
            myMatrix.write(7, 6, 0);
        }
        if (gCmdTmp == FORWARD){
            myMatrix.write(3, 5, 0); // 前方移動の表示を消す
            myMatrix.write(4, 5, 0);
        }
        if (gCmdTmp == BACKWARD){
            myMatrix.write(3, 7, 0); // 後方移動の表示を消す
            myMatrix.write(4, 7, 0);
        }
        if (gCmdTmp == NEUTRAL){
            myMatrix.write(3, 6, 0); // 移動なし表示を消す
            myMatrix.write(4, 6, 0);
        }
    }
    // 移動方向表示
    if (cmd == LEFT){
        myMatrix.write(0, 6, 1);     // 左回転移動の表示を点灯
        myMatrix.write(1, 6, 1);
    }
    if (cmd == RIGHT){
        myMatrix.write(6, 6, 1);     // 右回転移動の表示を点灯
        myMatrix.write(7, 6, 1);
    }
    if (cmd == FORWARD){
        myMatrix.write(3, 5, 1);     // 前方移動の表示を点灯
        myMatrix.write(4, 5, 1);
    }
    if (cmd == BACKWARD){
        myMatrix.write(3, 7, 1);     // 後方移動の表示を点灯
        myMatrix.write(4, 7, 1);
    }
    if (cmd == NEUTRAL){
        myMatrix.write(3, 6, 1);     // 移動なし表示を点灯
        myMatrix.write(4, 6, 1);
    }
    gCmdTmp = cmd;

    delay(100);
}
