//-----------------------------------------------------------------------
// @file ColorSensor2.ino
// @brief カラーセンサーから取得できたClear値(カラーフィルターを通っていない光の強さ)を使って、白、黒の判定をする
// 判定の閾値は、調整する
// 黒と判定するとポート１３接続のArduino基板LEDが点灯する、スピーカーから音がする
// @date Created on: 2014/07/16
// @author Masaharu Shimizu@@fuRo
//-----------------------------------------------------------------------
// Copyright (c) 2014 Future Robotics Technology Center (fuRo), Masaharu Shimizu All rights reserved.<BR>
//-----------------------------------------------------------------------

#include <RPlib.h>
#include <ColorSensor.h>
#include "pitches.h"

byte Led     = 13;
byte Speaker = D2;

void setup(){
    Serial.begin(9600);
    ColorSensor.begin(24, 3);                          //１項目：カラーセンサーの積分時間を指定 x0.1[ms]　 値が大きいほどセンサー値の精度が良くなるが、そのぶん時間がかかる　100で10[ms] ２項目：この場合、ゲインは3(３倍にしている)
    pinMode(Led, OUTPUT);
    ColorSensor.led(3);                                //LED3を点灯させる
}

void loop(){
    if (ColorSensor.colorRead()){
        word clear   = ColorSensor.colorClear();
        bool isBlack = ColorSensor.colorIsBlack(1000); //1000の値を小さくしていくとセンサーと黒い色見本が1cmのところで白黒判定できる値が見つかります。
        if(isBlack){
            digitalWrite(Led, HIGH);
            tone(Speaker, NOTE_F2, 50);
        }
        else {
            digitalWrite(Led, LOW);
        }

        Serial.print("colorClear:");
        Serial.print(clear);

        Serial.print(" isBlack:");
        Serial.println(isBlack);

        delay(50);
    }
}
