/*!
 * @file OneDotCamera.ino
 * @brief カラーセンサーとカラーLEDをつかった、1ドットのカメラを実現する
 *
 * Copyright (c) 2014 Future Robotics Technology Center (fuRo), Masaharu Shimizu All rights reserved.<BR>
 *
 * @date Created on: 2014/07/10
 * @author Masaharu Shimizu@@fuRo
 */


#include <ColorSensor.h>
#include <PS2X_lib.h>
#include "pitches.h"
#include <math.h>

PS2X ps2x;
int Speaker = 2;
int swPin = 10;
word red, green, blue;
word red2, green2, blue2;

word h1,h2;
word s1,s2;

void setup(){
    Serial.begin(9600);
    ps2x.config_gamepad(13,11,10,12, true, true); //コントローラーを使うときのオマジナイ
    ColorSensor.begin(4000);                      //カラーセンサーの積分時間を指定 x10[ms]　 値が大きいほどセンサー値の精度が良くなるが、そのぶん時間がかかる　100で10[ms] 最大 6144
}

void loop(){
    ps2x.read_gamepad();
    bool isShotButton1 = ps2x.ButtonPressed(PSB_RED);
    bool isShotButton2 = ps2x.ButtonPressed(PSB_PINK);
    bool isShowButton1 = ps2x.Button(PSB_BLUE);
    bool isShowButton2 = ps2x.Button(PSB_GREEN);

    if(isShotButton1){
        tone(Speaker, NOTE_C3, 100);
        if (ColorSensor.colorRead()){
            red = ColorSensor.colorRed();
            green = ColorSensor.colorGreen();
            blue = ColorSensor.colorBlue();
        }
        ColorSensor.convertHSV(red, green, blue);
        h1 = ColorSensor.convertH();
        s1 = ColorSensor.convertS();
        Serial.print("H1:");
        Serial.println(h1);
        delay(100);
    }

#if 1
    if(isShotButton2){
        tone(Speaker, NOTE_E3, 100);
        if (ColorSensor.colorRead()){
            red2 = ColorSensor.colorRed();
            green2 = ColorSensor.colorGreen();
            blue2 = ColorSensor.colorBlue();
        }
        ColorSensor.convertHSV(red2, green2, blue2);
        h2 = ColorSensor.convertH();
        s2 = ColorSensor.convertS();
        Serial.print("H2:");
        Serial.println(h2);
        delay(100);
    }

    if(isShowButton1){
        tone(Speaker, NOTE_A1, 100);

        word avgRed = ( red + red2 ) / 2;
        word avgGreen = ( green + green2 ) / 2;
        word avgBlue = ( blue + blue2 ) / 2;

        ColorSensor.convertHSV(avgRed, avgGreen, avgBlue);

        float x = ( cos((float)h1 / 180 * 3.14) + cos((float)h2 / 180 * 3.14)) / 2;
        float y = ( sin((float)h1 / 180 * 3.14) + sin((float)h2 / 180 * 3.14)) / 2;

        float avgH = atan2(y, x) / 3.14 * 180;
        if(avgH < 0){
            avgH = avgH + 360;
        }

        ColorSensor.convertRGB((word)avgH);
        byte ledRed = ColorSensor.convertRed();
        byte ledGreen = ColorSensor.convertGreen();
        byte ledBlue = ColorSensor.convertBlue();
        ColorSensor.ledRGB(ledRed, ledGreen, ledBlue);
        Serial.print(ledRed);
        Serial.print(" ");
        Serial.print(ledGreen);
        Serial.print(" ");
        Serial.print(ledBlue);
        Serial.print(" avgH1:");
        Serial.println(avgH);
        delay(100);
    }
    else
    if(isShowButton2)
    {
        tone(Speaker, NOTE_B1, 100);
        ColorSensor.convertRGB(ColorSensor.convertH());
        byte ledRed = ColorSensor.convertRed();
        byte ledGreen = ColorSensor.convertGreen();
        byte ledBlue = ColorSensor.convertBlue();
        ColorSensor.ledRGB(ledRed, ledGreen, ledBlue);

        Serial.print(ledRed);
        Serial.print(" ");
        Serial.print(ledGreen);
        Serial.print(" ");
        Serial.print(ledBlue);
        Serial.print(" avgH2:");
        Serial.println(ColorSensor.convertH());
        delay(100);
    }
    else {
        ColorSensor.ledRGB(0, 0, 0);
    }
    delay(20);
#endif
}
