/*!
 * @file OneDotCamera.ino
 * @brief カラーセンサーとカラーLEDをつかった、1ドットのカメラを実現する
 *
 * Copyright (c) 2014 Future Robotics Technology Center (fuRo), Masaharu Shimizu All rights reserved.<BR>
 *
 * @date Created on: 2014/07/10
 * @author Masaharu Shimizu@@fuRo
 */

#include <ColorSensor.h>
#include <PS2X_lib.h>
#include "pitches.h"

PS2X ps2x;
int Speaker = 2;
int swPin = 10;
word red, green, blue;

void setup(){
    ps2x.config_gamepad(13,11,10,12, true, true); //コントローラーを使うときのオマジナイ
    ColorSensor.begin(4000);                      // カラーセンサーの積分時間を指定 x10[ms]　 値が大きいほどセンサー値の精度が良くなるが、そのぶん時間がかかる　100で10[ms] 最大 6144
}

void loop(){
    ps2x.read_gamepad();
    bool isShotButton = ps2x.ButtonPressed(PSB_RED);
    bool isShowButton = ps2x.Button(PSB_BLUE);

    if(isShotButton){
        tone(Speaker, NOTE_C3, 100);
        delay(600);
        if (ColorSensor.colorRead()){
            red = ColorSensor.colorRed();
            green = ColorSensor.colorGreen();
            blue = ColorSensor.colorBlue();
        }
    }

    if(isShowButton){
        tone(Speaker, NOTE_A1, 100);
        ColorSensor.convertHSV(red, green, blue);
        word h = ColorSensor.convertH();
        word s = ColorSensor.convertS();
        ColorSensor.convertRGB(h);
        byte ledRed = ColorSensor.convertRed();
        byte ledGreen = ColorSensor.convertGreen();
        byte ledBlue = ColorSensor.convertBlue();
        if(s < 6){
            ColorSensor.ledRGB(100, 100, 100);
        }
        else {
            ColorSensor.ledRGB(ledRed, ledGreen, ledBlue);
        }
        delay(100);
    }
    else {
        ColorSensor.ledRGB(0, 0, 0);
    }
    delay(10);
}
