/*!
 * @file ColorLED2.ino
 * @brief LEDの光の強さ(輝度)を変化できることをボタン連打で体験、輝度が違う三原色が混ざると、中間色ができることを体験
 * 輝度と色相の関係を体験しよう
 *
 * Copyright (c) 2014 Future Robotics Technology Center (fuRo), Masaharu Shimizu All rights reserved.<BR>
 *
 * @date Created on: 2014/07/15
 * @author Masaharu Shimizu@@fuRo
 */

#include <ColorSensor.h>
#include <PS2X_lib.h>
#include "pitches.h"

int Speaker = 2;
PS2X ps2x;
byte red(0), green(0), blue(0);

void setup(){
    ps2x.config_gamepad(13,11,10,12, true, true); //コントローラーを使うときのオマジナイ
    ColorSensor.begin(100);                       //カラーセンサーの積分時間を指定 x10[ms]　 値が大きいほどセンサー値の精度が良くなるが、そのぶん時間がかかる　100で10[ms] 最大 6144
    Serial.begin(9600);
}

void loop(){
    ps2x.read_gamepad();

    if(ps2x.ButtonPressed(PSB_RED)){
        if(red < 100){
            red = red + 1;
        }
        if(red == 100){
            tone(Speaker, NOTE_A3, 10);
        }
    }

    if(ps2x.ButtonPressed(PSB_GREEN)){
        if(green < 100){
            green = green + 1;
        }
        if(green == 100){
            tone(Speaker, NOTE_B3, 10);
        }
    }

    if(ps2x.ButtonPressed(PSB_BLUE)){
        if(blue < 100){
            blue = blue + 1;
        }
        if(blue == 100){
            tone(Speaker, NOTE_C3, 10);
        }
    }

    if(ps2x.ButtonPressed(PSB_PAD_RIGHT)){
        if(red > 0){
            red = red - 1;
        }
    }
    if(ps2x.ButtonPressed(PSB_PAD_UP)){
        if(green > 0){
            green = green - 1;
        }
    }
    if(ps2x.ButtonPressed(PSB_PAD_DOWN)){
        if(blue > 0){
            blue = blue - 1;
        }
    }

    if(ps2x.ButtonPressed(PSB_PAD_LEFT)){
        red = 0;
        green = 0;
        blue = 0;
    }

    ColorSensor.ledRGB(red, green, blue);

    Serial.print("RED:");
    Serial.print(red);

    Serial.print(" GREEN:");
    Serial.print(green);

    Serial.print(" BLUE:");
    Serial.println(blue);


    delay(30);
}
