/*!
 * @file ColorLED1.ino
 * @brief フルカラーLEDの各赤、緑、青の三原色をコントローラーのボタンで点灯させて、色を混ぜて、何色になるか体験する
 *
 * Copyright (c) 2014 Future Robotics Technology Center (fuRo), Masaharu Shimizu All rights reserved.<BR>
 *
 * @date Created on: 2014/07/15
 * @author Masaharu Shimizu@@fuRo
 */

#include <ColorSensor.h>
#include <PS2X_lib.h>

PS2X ps2x;

void setup(){
    ps2x.config_gamepad(13,11,10,12, true, true); //コントローラーを使うときのオマジナイ
    ColorSensor.begin(100);                       //カラーセンサーの積分時間を指定 x10[ms]　 値が大きいほどセンサー値の精度が良くなるが、そのぶん時間がかかる　100で10[ms] 最大 6144
}

void loop(){
    ps2x.read_gamepad();

    byte red(0), green(0), blue(0);

    if(ps2x.Button(PSB_RED)){
        red = 100;
    }

    if(ps2x.Button(PSB_GREEN)){
        green = 100;
    }

    if(ps2x.Button(PSB_BLUE)){
        blue = 100;
    }

    ColorSensor.ledRGB(red, green, blue);

    delay(10);
}
