/*!
 * @file ColorLED0.ino
 * @brief LEDを順番に点灯させる
 *
 * Copyright (c) 2014 Future Robotics Technology Center (fuRo), Masaharu Shimizu All rights reserved.<BR>
 *
 * @date Created on: 2014/07/18
 * @author Masaharu Shimizu@@fuRo
 */

#include <ColorSensor.h>

void setup(){
    ColorSensor.begin(100);        //カラーセンサーの積分時間を指定 x10[ms]　 値が大きいほどセンサー値の精度が良くなるが、そのぶん時間がかかる　100で10[ms] 最大 6144
}

void loop(){
    for(int i = 0; i < 8; i++){
        ColorSensor.led(i, 10);
        delay(200);
        ColorSensor.led(i, 0);
        delay(200);
    }
}
