//-----------------------------------------------------------------------
// 　超音波距離センサーをテストする
// 不思議楽器テルミン1
// US1のみで演奏する
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

//ライブラリを取り込む
#include <Sprite.h>
#include <Matrix.h>
#include <Tone.h>
#include <RPlib.h>

Matrix myMatrix = Matrix(11, 13, 1); //マトリクスLEDを使うときのオマジナイ
Tone tone1;                          //スピーカーを使うときのオマジナイ

void setup(){
    myMatrix.setBrightness(8);       //マトリクスLEDの明るさを設定(0−8)
    tone1.begin(D3);                 //D3にスピーカーを接続
}

void loop(){
    int dist;
    myMatrix.clear();
    dist = ussRead(US1);        //US1から距離情報を取得
    myMatrix.putd2(0, 0, dist); //マトリクスLEDに2けたの数字を表示
    tone1.play(dist * 20, 100); //dist*20Hzの音を出す
    delay(100);                 //100msec待つ
}
