//-----------------------------------------------------------------------
// 　超音波距離センサーをテストする1 センサーの動作確認
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------

//ライブラリを取り込む
#include <Sprite.h>
#include <Matrix.h>
#include <RPlib.h>

Matrix myMatrix = Matrix(11, 13, 1);  //マトリクスLEDを使うときのオマジナイ

void setup(){
    myMatrix.setBrightness(8);        //マトリクスLEDの明るさを設定(0−8)
}

void loop(){
    int dist1;                   //変数をdist1という名前で使う
    int dist2;                   //変数をdist2という名前で使う
    myMatrix.clear();
    dist1 = ussRead(US1);        //US1の距離データを変数dist1に入れる
    dist2 = ussRead(US2);        //US2の距離データを変数dist2に入れる
    
    if(dist1 <= 30){             //US1に接続された超音波距離センサーの30センチ以内に近づいたら
        myMatrix.putch(0,0,'1'); //'1'をマトリクスLEDに表示する
    }
    else if(dist2 <= 10){        //US2に接続された超音波距離センサーの10センチ以内に近づいたら
        myMatrix.putch(0,0,'2'); //'2'をマトリクスLEDに表示する
    }
    else{
        myMatrix.putch(0,0,'0'); //'0'をマトリクスLEDに表示する
    }
    delay(100);
}
