//-----------------------------------------------------------------------
// マトリクスLEDを使ったコントローラーの動作確認(バリバリチューン)
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
//ライブラリを読み込む
#include <PS2X_lib.h>
#include <Sprite.h>
#include <Matrix.h>
#include <Tone.h>
#include <RPlib.h>
#include <math.h>

PS2X ps2x;
Tone tone1;
Matrix myMatrix = Matrix(11, 13, 1);                 //マトリクスLEDを使うときのオマジナイ

char *song1     = "M2A:d=4,o=6,b=180:16g,16c7,16f7,16p,16c7,16d7,16g7,16p,16g,16c7,16d7,16f7,16g7,16d7,16c7,16d7";
char *song2     = "M1A:d=4,o=5,b=120:16g,16c6,16g5,16c6,16g5,16c6";
char *song3     = "M4A:d=4,o=4,b=170:16g,16c5,16p,16g,16c5,16p,16g,16c5,16p,16e5";
char *song4     = "M3A:d=4,o=4,b=135:16g,16c5,16p,16b,16a,16p,16g,16p,16a,16p,16e,16p,16g";

int vibrate     = 0;                                 //変数intをvibrateという名前で使う(はじめは0)
double oct      = 1;                                 //変数intをoct(オクターブ)という名前で使う(はじめは1)
int effect      = 0;                                 //変数intをeffect(エフェクト)という名前で使う(はじめは0)

void setup(){
    ps2x.config_gamepad(13, 11, 10, 12, true, true); //コントローラーを使うときのオマジナイ
    tone1.begin(D2);                                 //D2にスピーカーを接続
    myMatrix.clear();                                //マトリクスLEDの表示を消す
    myMatrix.setBrightness(3);                       //マトリクスLEDの明るさを設定(0−8)
}

void loop(){
    ps2x.read_gamepad(false, vibrate);               //コントローラーから値を読み取る

    //-------------
    // 特殊複合キー
    //-------------
    if (ps2x.Button(PSB_L2)){                        //もしL2ボタンがおされたら
        oct = 2;                                     //オクターブを上げる
    }
    else if (ps2x.Button(PSB_R2)){                   //もしR2ボタンがおされたら
        oct = 1.0593;                                //pow(2,1/12);//オクターブを上げる
    }
    else{                                            //そうでなかったら
        oct = 1;                                     //標準オクターブ
    }

    //-------------------------------------------------
    // アナログスティックで音をゆがめる(エフェクト計算)
    //-------------------------------------------------
    effect = ps2x.Analog(PSS_LY) + ps2x.Analog(PSS_RY) + 2 * ( ps2x.Analog(PSS_LX) + ps2x.Analog(PSS_RX));

    //-------------
    // 標準音階キー
    //-------------
    if (ps2x.Button(PSB_PAD_UP)){                //もし十字ボタンの上がおされたら
        myMatrix.putch(0, 0, 'A');               //”A”を表示
        tone1.play(oct * NOTE_C4 + effect, 20);
    }

    if (ps2x.Button(PSB_PAD_RIGHT)){             //もし十字ボタンの右がおされたら
        myMatrix.putch(0, 0, 'B');               //”B”を表示
        tone1.play(oct * NOTE_D4 + effect, 20);
    }

    if (ps2x.Button(PSB_PAD_DOWN)){              //もし十字ボタンの下がおされたら
        myMatrix.putch(0, 0, 'C');               //”C”を表示
        tone1.play(oct * NOTE_E4 + effect, 20);
    }

    if (ps2x.Button(PSB_PAD_LEFT)){              //もし十字ボタンの左がおされたら
        myMatrix.putch(0, 0, 'D');               //”D”を表示
        tone1.play(oct * NOTE_F4 + effect, 20);
    }

    if (ps2x.Button(PSB_GREEN)){                 //もし緑ボタンがおされたら
        myMatrix.putch(0, 0, 'E');               //”E”を表示
        tone1.play(oct * NOTE_G4 + effect, 20);
    }

    if (ps2x.Button(PSB_RED)){                   //もし赤ボタンがおされたら
        myMatrix.putch(0, 0, 'F');               //”F”を表示
        tone1.play(oct * NOTE_A4 + effect, 20);
    }

    if (ps2x.Button(PSB_BLUE)){                  //もし青ボタンがおされたら
        myMatrix.putch(0, 0, 'G');               //”G”を表示
        tone1.play(oct * NOTE_B4 + effect, 20);
    }

    if (ps2x.Button(PSB_PINK)){                  //もしピンクボタンがおされたら
        myMatrix.putch(0, 0, 'H');               //”H”を表示
        tone1.play(oct * NOTE_C5 + effect, 20);
    }

    if (ps2x.Button(PSB_L1)){                    //もしL1ボタンがおされたら
        myMatrix.putch(0, 0, 'I');               //”I”を表示
        tone1.play(oct * NOTE_CS4 + effect, 20); //C#4
    }

    if (ps2x.Button(PSB_R1)){                    //もしR1ボタンがおされたら
        myMatrix.putch(0, 0, 'K');               //”K”を表示
        tone1.play(oct * NOTE_FS4 + effect, 20); //F#4
    }

    //-----------------------------------------------------------
    // 自動演奏キー設定 (おされた瞬間を判別するためPressedを使用)
    //-----------------------------------------------------------
    if (ps2x.ButtonPressed(PSB_R3)){             //もしR3ボタンがおされたら
        myMatrix.putch(0, 0, 0xe1);              //星を表示
        tone1.play_rtttl(song1);
    }

    if (ps2x.ButtonPressed(PSB_L3)){             //もしL3ボタンがおされたら
        myMatrix.putch(0, 0, 0xea);              //三角を表示
        tone1.play_rtttl(song2);
    }

    if (ps2x.ButtonPressed(PSB_START)){          //もしスタートボタンがおされたら
        myMatrix.putch(0, 0, 0xe3);              //丸を表示
        tone1.play_rtttl(song3);
    }

    if (ps2x.ButtonPressed(PSB_SELECT)){         //もしセレクトボタンがおされたら
        myMatrix.putch(0, 0, 0xe8);              //四角を表示
        tone1.play_rtttl(song4);
    }

    delay(10);
}
