//-----------------------------------------------------------------------
// ライフゲーム
//-----------------------------------------------------------------------
// Copyright (C) Future Robotics Technology Center All Right Reserved
//-----------------------------------------------------------------------
//ライブラリを読み込む
#include <Sprite.h>
#include <Matrix.h>
#include <RPlib.h>

Matrix myMatrix = Matrix(11,13,1); //マトリクスLEDを使うときのオマジナイ
int x,y;                           //変数intをxとyという名前で使う
int s;                             //変数intをsという名前で使う(判定用の変数)

//cellマトリクスデータ(二次元配列)
//座標がついているようなデータにはわかりやすいので使用する
int cell[10][10] =
{
    {0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0},
    {0,0,1,1,1,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,1,0,0,0},
    {0,0,0,0,0,0,1,0,0,0},
    {0,0,0,0,0,0,1,0,0,0},
    {0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0}
};

int newcell[10][10];                              //更新用配列

void setup(){
    myMatrix.clear();                             //マトリクスLEDの表示を消す
    myMatrix.setBrightness(3);                    //マトリクスLEDの明るさを設定(0−8)
}

void loop(){
    //---------------------------------
    // 画面に表示(端から順番にチェック)
    //---------------------------------
    for (x = 1; x < 9; x++){
        for (y = 1; y < 9; y++){
            if (cell[x][y] == 0){                 //もしセルデータが0だったら
                myMatrix.write(x - 1,y - 1,LOW);  //LEDを消灯
            }
            else{                                 //そうでなかった（セルデータが１だった）ら
                myMatrix.write(x - 1,y - 1,HIGH); //LEDを点灯
            }
        }
    }

    //-----------------
    // ドットの生死判定
    //-----------------
    for (x = 1; x < 9; x++){
        for (y = 1; y < 9; y++){
            //周りの状況をみる
            s = cell[x - 1][y - 1] + cell[x - 1][y] + cell[x - 1][y + 1] + cell[x][y - 1] + cell[x][y + 1]   + cell[x + 1][y + 1] + cell[x + 1][y] + cell[x + 1][y - 1];
            //ルール適用
            if (s == 2){                          //もし2つ確認すれば生存
                newcell[x][y] = cell[x][y];
            }
            else if(s == 3){                      //もし3つ確認すれば誕生
                newcell[x][y] = 1;
            }
            else{                                 //そうでなかったら死滅
                newcell[x][y] = 0;
            }
        }
    }

    //-----------
    // データ更新
    //-----------
    for(x = 0; x < 10; x++){
        for(y = 0; y < 10; y++){
            cell[x][y] = newcell[x][y];           //更新した新しいセルデータを表示データに反映
        }
    }

    delay(200);
}
